% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectations.R
\name{call-expectations}
\alias{call-expectations}
\alias{expect_call}
\alias{expect_args}
\alias{expect_called}
\title{Expectation: does the given call match the expected?}
\usage{
expect_call(mock_object, n, expected_call)

expect_args(mock_object, n, ...)

expect_called(mock_object, n)
}
\arguments{
\item{mock_object}{A \code{\link{mock}} object.}

\item{n}{Call number or total number of calls.}

\item{expected_call}{Expected call expression; will be compared unevaluated.}

\item{...}{Arguments as passed in a call.}
}
\description{
Together with \code{\link{mock}} can be used to verify whether the
call expression (\code{\link{expect_call}}) and/or argument values
(\code{\link{expect_args}}) match the expected.
}
\details{
With \code{expect_called} you can check how many times has the mock
object been called.
}
\examples{
library(testthat)

# expect call expression (signature)
m <- mock()
m(iris)

# it has been called once
expect_called(m, 1)

# the first (and only) call's arguments matches summary(iris)
expect_call(m, 1, m(iris))

# expect argument value
m <- mock()
a <- iris
m(object = a)
expect_args(m, 1, object = a)
# is an equivalent to ...
expect_equal(mock_args(m)[[1]], list(object = a))

}
