% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractFDAFeaturesMethods.R
\name{extractFDAFPCA}
\alias{extractFDAFPCA}
\title{Extract functional principal component analysis features.}
\usage{
extractFDAFPCA(rank. = NULL, center = TRUE, scale. = FALSE)
}
\arguments{
\item{rank.}{(\code{integer(1)})\cr
Number of principal components to extract.
Default is \code{NULL}}

\item{center}{(\code{logical(1)}) \cr
Should data be centered before applying PCA?}

\item{scale.}{(\code{logical(1)}) \cr
Should data be scaled before applying PCA?}
}
\value{
(\link{data.frame}).
}
\description{
The function extracts the functional principal components from a data.frame
containing functional features. Uses \code{stats::prcomp}.
}
\seealso{
Other fda_featextractor: 
\code{\link{extractFDABsignal}()},
\code{\link{extractFDADTWKernel}()},
\code{\link{extractFDAFourier}()},
\code{\link{extractFDAMultiResFeatures}()},
\code{\link{extractFDATsfeatures}()},
\code{\link{extractFDAWavelets}()}
}
\concept{fda_featextractor}
