% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpTorchFTCLS.R
\name{nn_ft_cls}
\alias{nn_ft_cls}
\title{CLS Token for FT-Transformer}
\usage{
nn_ft_cls(d_token, initialization)
}
\arguments{
\item{d_token}{(\code{integer(1)})\cr
The dimension of the embedding.}

\item{initialization}{(\code{character(1)})\cr
The initialization method for the embedding weights. Possible values are \code{"uniform"}
and \code{"normal"}.}
}
\description{
Concatenates a CLS token to the input as the last feature.
The input shape is expected to be \verb{(batch, n_features, d_token)} and the output shape is
\verb{(batch, n_features + 1, d_token)}.

This is used in the \code{\link{LearnerTorchFTTransformer}}.
}
\references{
Devlin, Jacob, Chang, Ming-Wei, Lee, Kenton, Toutanova, Kristina (2018).
\dQuote{Bert: Pre-training of deep bidirectional transformers for language understanding.}
\emph{arXiv preprint arXiv:1810.04805}.
}
