% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackSet.R
\name{mlr_callback_set}
\alias{mlr_callback_set}
\alias{CallbackSet}
\title{Base Class for Callbacks}
\description{
Base class from which callbacks should inherit (see section \emph{Inheriting}).
A callback set is a collection of functions that are executed at different stages of the training loop.
They can be used to gain more control over the training process of a neural network without
having to write everything from scratch.

When used a in torch learner, the \code{CallbackSet} is wrapped in a \code{\link{TorchCallback}}.
The latters parameter set represents the arguments of the \code{\link{CallbackSet}}'s \verb{$initialize()} method.
}
\section{Inheriting}{

For each available stage (see section \emph{Stages}) a public method \verb{$on_<stage>()} can be defined.
The evaluation context (a \code{\link{ContextTorch}}) can be accessed via \code{self$ctx}, which contains
the current state of the training loop.
This context is assigned at the beginning of the training loop and removed afterwards.
Different stages of a callback can communicate with each other by assigning values to \verb{$self}.

\emph{State}:
To be able to store information in the \verb{$model} slot of a \code{\link{LearnerTorch}}, callbacks support a state API.
You can overload the \verb{$state_dict()} public method to define what will be stored in \verb{learner$model$callbacks$<id>}
after training finishes.
This then also requires to implement a \verb{$load_state_dict(state_dict)} method that defines how to load a previously saved
callback state into a different callback.
Note that the \verb{$state_dict()} should not include the parameter values that were used to initialize the callback.

For creating custom callbacks, the function \code{\link[=torch_callback]{torch_callback()}} is recommended, which creates a
\code{CallbackSet} and then wraps it in a \code{\link{TorchCallback}}.
To create a \code{CallbackSet} the convenience function \code{\link[=callback_set]{callback_set()}} can be used.
These functions perform checks such as that the stages are not accidentally misspelled.
}

\section{Stages}{

\itemize{
\item \code{begin} :: Run before the training loop begins.
\item \code{epoch_begin} :: Run he beginning of each epoch.
\item \code{batch_begin} :: Run before the forward call.
\item \code{after_backward} :: Run after the backward call.
\item \code{batch_end} :: Run after the optimizer step.
\item \code{batch_valid_begin} :: Run before the forward call in the validation loop.
\item \code{batch_valid_end} :: Run after the forward call in the validation loop.
\item \code{valid_end} :: Run at the end of validation.
\item \code{epoch_end} :: Run at the end of each epoch.
\item \code{end} :: Run after last epoch.
\item \code{exit} :: Run at last, using \code{on.exit()}.
}
}

\section{Terminate Training}{

If training is to be stopped, it is possible to set the field \verb{$terminate} of \code{\link{ContextTorch}}.
At the end of every epoch this field is checked and if it is \code{TRUE}, training stops.
This can for example be used to implement custom early stopping.
}

\seealso{
Other Callback: 
\code{\link{TorchCallback}},
\code{\link{as_torch_callback}()},
\code{\link{as_torch_callbacks}()},
\code{\link{callback_set}()},
\code{\link{mlr3torch_callbacks}},
\code{\link{mlr_callback_set.checkpoint}},
\code{\link{mlr_callback_set.progress}},
\code{\link{mlr_callback_set.tb}},
\code{\link{mlr_callback_set.unfreeze}},
\code{\link{mlr_context_torch}},
\code{\link{t_clbk}()},
\code{\link{torch_callback}()}
}
\concept{Callback}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{ctx}}{(\code{\link{ContextTorch}} or \code{NULL})\cr
The evaluation context for the callback.
This field should always be \code{NULL} except during the \verb{$train()} call of the torch learner.}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{stages}}{(\code{character()})\cr
The active stages of this callback set.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CallbackSet-print}{\code{CallbackSet$print()}}
\item \href{#method-CallbackSet-state_dict}{\code{CallbackSet$state_dict()}}
\item \href{#method-CallbackSet-load_state_dict}{\code{CallbackSet$load_state_dict()}}
\item \href{#method-CallbackSet-clone}{\code{CallbackSet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSet-print"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSet-print}{}}}
\subsection{Method \code{print()}}{
Prints the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSet$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{(any)\cr
Currently unused.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSet-state_dict"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSet-state_dict}{}}}
\subsection{Method \code{state_dict()}}{
Returns information that is kept in the the \code{\link{LearnerTorch}}'s state after training.
This information should be loadable into the callback using \verb{$load_state_dict()} to be able to continue training.
This returns \code{NULL} by default.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSet$state_dict()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSet-load_state_dict"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSet-load_state_dict}{}}}
\subsection{Method \code{load_state_dict()}}{
Loads the state dict into the callback to continue training.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSet$load_state_dict(state_dict)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{state_dict}}{(any)\cr
The state dict as retrieved via \verb{$state_dict()}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CallbackSet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CallbackSet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CallbackSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
