% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResamplingRepeatedSptCVCstf.R
\name{mlr_resamplings_repeated_sptcv_cstf}
\alias{mlr_resamplings_repeated_sptcv_cstf}
\alias{ResamplingRepeatedSptCVCstf}
\title{(CAST) Repeated spatiotemporal "leave-location-and-time-out" resampling}
\description{
Splits data using Leave-Location-Out (LLO), Leave-Time-Out (LTO) and
Leave-Location-and-Time-Out (LLTO) partitioning.
See the upstream implementation at \code{CreateSpacetimeFolds()}
(package \CRANpkg{CAST}) and Meyer et al. (2018) for further information.
}
\details{
LLO predicts on unknown locations i.e. complete locations are left out in the
training sets.
The \code{"space"} role in \code{Task$col_roles} identifies spatial units.
If \code{stratify} is \code{TRUE}, the target distribution is similar in each fold.
This is useful for land cover classification when the observations
are polygons.
In this case, LLO with stratification should be used to hold back complete
polygons and have a similar target distribution in each fold.
LTO leaves out complete temporal units which are identified by the
\code{"time"} role in \code{Task$col_roles}.
LLTO leaves out spatial and temporal units.
See the examples.
}
\section{Parameters}{

\itemize{
\item \code{folds} (\code{integer(1)})\cr
Number of folds.
\item \code{stratify}\cr
If \code{TRUE}, stratify on the target column.
}


\itemize{
\item \code{repeats} (\code{integer(1)})\cr
Number of repeats.
}
}

\examples{
\donttest{
library(mlr3)
task = tsk("cookfarm_mlr3")
task$set_col_roles("SOURCEID", roles = "space")
task$set_col_roles("Date", roles = "time")

# Instantiate Resampling
rcv = rsmp("repeated_sptcv_cstf", folds = 5, repeats = 2)
rcv$instantiate(task)

### Individual sets:
# rcv$train_set(1)
# rcv$test_set(1)
# check that no obs are in both sets
intersect(rcv$train_set(1), rcv$test_set(1)) # good!

# Internal storage:
# rcv$instance # table
}
}
\references{
Zhao Y, Karypis G (2002).
\dQuote{Evaluation of Hierarchical Clustering Algorithms for Document Datasets.}
\emph{11th Conference of Information and Knowledge Management (CIKM)}, 51-524.
\doi{https://doi.org/10.1145/584792.584877}.
}
\section{Super class}{
\code{\link[mlr3:Resampling]{mlr3::Resampling}} -> \code{ResamplingRepeatedSptCVCstf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Returns the number of resampling iterations, depending on the
values stored in the \code{param_set}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ResamplingRepeatedSptCVCstf-new}{\code{ResamplingRepeatedSptCVCstf$new()}}
\item \href{#method-ResamplingRepeatedSptCVCstf-folds}{\code{ResamplingRepeatedSptCVCstf$folds()}}
\item \href{#method-ResamplingRepeatedSptCVCstf-repeats}{\code{ResamplingRepeatedSptCVCstf$repeats()}}
\item \href{#method-ResamplingRepeatedSptCVCstf-instantiate}{\code{ResamplingRepeatedSptCVCstf$instantiate()}}
\item \href{#method-ResamplingRepeatedSptCVCstf-clone}{\code{ResamplingRepeatedSptCVCstf$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="format"><a href='../../mlr3/html/Resampling.html#method-Resampling-format'><code>mlr3::Resampling$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="help"><a href='../../mlr3/html/Resampling.html#method-Resampling-help'><code>mlr3::Resampling$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="print"><a href='../../mlr3/html/Resampling.html#method-Resampling-print'><code>mlr3::Resampling$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="test_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-test_set'><code>mlr3::Resampling$test_set()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Resampling" data-id="train_set"><a href='../../mlr3/html/Resampling.html#method-Resampling-train_set'><code>mlr3::Resampling$train_set()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSptCVCstf-new"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSptCVCstf-new}{}}}
\subsection{Method \code{new()}}{
Create a "Spacetime Folds" resampling instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$new(id = "repeated_sptcv_cstf")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{\code{character(1)}\cr
Identifier for the resampling strategy.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSptCVCstf-folds"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSptCVCstf-folds}{}}}
\subsection{Method \code{folds()}}{
Translates iteration numbers to fold number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$folds(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSptCVCstf-repeats"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSptCVCstf-repeats}{}}}
\subsection{Method \code{repeats()}}{
Translates iteration numbers to repetition number.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$repeats(iters)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{iters}}{\code{integer()}\cr
Iteration number.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSptCVCstf-instantiate"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSptCVCstf-instantiate}{}}}
\subsection{Method \code{instantiate()}}{
Materializes fixed training and test splits for a given task.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$instantiate(task)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{task}}{\link[mlr3:Task]{mlr3::Task}\cr
A task to instantiate.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ResamplingRepeatedSptCVCstf-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ResamplingRepeatedSptCVCstf-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ResamplingRepeatedSptCVCstf$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
