% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{miscmethods.mlogit}
\alias{miscmethods.mlogit}
\alias{residuals.mlogit}
\alias{df.residual.mlogit}
\alias{terms.mlogit}
\alias{model.matrix.mlogit}
\alias{model.response.mlogit}
\alias{update.mlogit}
\alias{print.mlogit}
\alias{logLik.mlogit}
\alias{summary.mlogit}
\alias{print.summary.mlogit}
\alias{predict.mlogit}
\alias{fitted.mlogit}
\alias{coef.mlogit}
\alias{coef.summary.mlogit}
\alias{idx.mlogit}
\alias{idx_name.mlogit}
\title{Methods for mlogit objects}
\usage{
\method{residuals}{mlogit}(object, outcome = TRUE, ...)

\method{df.residual}{mlogit}(object, ...)

\method{terms}{mlogit}(x, ...)

\method{model.matrix}{mlogit}(object, ...)

model.response.mlogit(object, ...)

\method{update}{mlogit}(object, new, ...)

\method{print}{mlogit}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{logLik}{mlogit}(object, ...)

\method{summary}{mlogit}(object, ..., type = c("chol", "cov", "cor"))

\method{print}{summary.mlogit}(
  x,
  digits = max(3, getOption("digits") - 2),
  width = getOption("width"),
  ...
)

\method{idx}{mlogit}(x, n = NULL, m = NULL)

\method{idx_name}{mlogit}(x, n = NULL, m = NULL)

\method{predict}{mlogit}(object, newdata = NULL, returnData = FALSE, ...)

\method{fitted}{mlogit}(
  object,
  type = c("outcome", "probabilities", "linpred", "parameters"),
  outcome = NULL,
  ...
)

\method{coef}{mlogit}(
  object,
  subset = c("all", "iv", "sig", "sd", "sp", "chol"),
  fixed = FALSE,
  ...
)

\method{coef}{summary.mlogit}(object, ...)
}
\arguments{
\item{outcome}{a boolean which indicates, for the `fitted` and the
`residuals` methods whether a matrix (for each choice, one
value for each alternative) or a vector (for each choice, only
a value for the alternative chosen) should be returned,}

\item{...}{further arguments.}

\item{x, object}{an object of class `mlogit`}

\item{new}{an updated formula for the `update` method,}

\item{digits}{the number of digits,}

\item{width}{the width of the printing,}

\item{type}{one of `outcome` (probability of the chosen
alternative), `probabilities` (probabilities for all the
alternatives), `parameters` for individual-level random
parameters for the fitted method, how the correlated random
parameters should be displayed : `"chol"` for the estimated
parameters (the elements of the Cholesky decomposition matrix),
`"cov"` for the covariance matrix and `"cor"` for the
correlation matrix and the standard deviations,}

\item{n, m}{see [dfidx::idx()]}

\item{newdata}{a `data.frame` for the `predict` method,}

\item{returnData}{for the `predict` method, if `TRUE`, the data is
returned as an attribute,}

\item{subset}{an optional vector of coefficients to extract for the
`coef` method,}

\item{fixed}{if `FALSE` (the default), constant coefficients are
not returned,}
}
\description{
Miscellaneous methods for `mlogit` objects.
}
