% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-experiments.R
\name{mlflow_restore_experiment}
\alias{mlflow_restore_experiment}
\title{Restore Experiment}
\usage{
mlflow_restore_experiment(experiment_id, client = NULL)
}
\arguments{
\item{experiment_id}{ID of the associated experiment. This field is required.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Restores an experiment marked for deletion. This also restores associated metadata,
  runs, metrics, and params. If experiment uses FileStore, underlying artifacts
  associated with experiment are also restored.
}
\details{
Throws `RESOURCE_DOES_NOT_EXIST` if the experiment was never created or was permanently deleted.
}
