% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSUR.R
\name{estimateSUR}
\alias{estimateSUR}
\title{EstimateSUR}
\usage{
estimateSUR(
  PPP,
  xi_PPP_X,
  integrated = TRUE,
  N_ppp,
  method = "discrete",
  SUR_pop,
  r = N.batch,
  optimcontrol = list(pop.size = 50 * d, max.generations = 10 * d),
  approx.pnorm,
  J = 0,
  N.batch = foreach::getDoParWorkers(),
  verbose = 0,
  ...
)
}
\arguments{
\item{PPP}{the Poisson point process generated to get alpha.}

\item{xi_PPP_X}{the output of xi(cbind(PPP$X, PPP$final_X)).}

\item{integrated}{boolean to specify of SUR criterion is standard or
integrated.}

\item{N_ppp}{the number of Poisson processes used for the SUR criterion estimation.}

\item{method}{eiter "genoud" for an optimisation using the package \code{rgenoud} or
"discrete" for a discrete search over \code{SUR_pop}.}

\item{SUR_pop}{if \code{optimcontrol$method=="discrete"}, SUR_pop is the population
onto which minimizer is sought. Should
be a matrix d x n.}

\item{r}{number of points to be added to the DoE.}

\item{optimcontrol}{a list of control parameters for the optimisation
of the SUR criterion using the \code{rgenoud} package.}

\item{approx.pnorm}{(optional) an approximation of base pnorm function running faster.}

\item{J}{the center of an interval of size 8 for pnorm approximation.}

\item{N.batch}{Number of batchs for parallel computation.}

\item{verbose}{to control the print level of the algorithm}

\item{...}{further arguments to be passed to fSUR.}
}
\value{
a list containing the points minimising the criterion
}
\description{
A function for estimating a SUR criterion with a realisation of a PPP
}
