parWrapper <- function(k, X, Y, init.obj, rho, ind, kfold, lamTh.vec, lamB.vec,
                       Beta.maxit, Beta.thr, Theta.maxit, Theta.thr, eps, eta) {
  
  n <- nrow(X); p <- ncol(X); q <- ncol(Y)
  
  err.fold <- rep(0, length(lamTh.vec))
  
  # Memory-efficient allocation
  if (length(lamTh.vec) > 100) {
    Beta.warm.fold <- vector("list", length(lamTh.vec))
  } else {
    Beta.warm.fold <- lapply(seq_along(lamTh.vec), function(x) matrix(0, p, q))
  }
  
  foldind <- ind[(1 + floor((k - 1) * n / kfold)) : floor(k * n / kfold)]
  X.tr <- X[-foldind, , drop = FALSE]
  Y.tr <- Y[-foldind, , drop = FALSE]
  X.va <- X[foldind, , drop = FALSE]
  Y.va <- Y[foldind, , drop = FALSE]
  n.tr <- nrow(X.tr); n.va <- nrow(X.va)
  
  if (is.null(rho)) {
    rho.vec    <- apply(Y.tr, 2, function(x) sum(is.na(x)) / n.tr)
    rho.vec.va <- apply(Y.va, 2, function(x) sum(is.na(x)) / n.va)
  } else {
    rho.vec <- rho.vec.va <- init.obj$rho.vec
  }
  
  rho.mat.1    <- matrix(1 - rho.vec,    nrow = p, ncol = q, byrow = TRUE)
  rho.mat.2    <- outer(1 - rho.vec, 1 - rho.vec, `*`); diag(rho.mat.2) <- 1 - rho.vec
  rho.mat.va.1 <- matrix(1 - rho.vec.va, nrow = p, ncol = q, byrow = TRUE)
  rho.mat.va.2 <- outer(1 - rho.vec.va, 1 - rho.vec.va, `*`); diag(rho.mat.va.2) <- 1 - rho.vec.va
  
  mx.tr <- apply(X.tr, 2, robust_mean)
  mx.va <- apply(X.va, 2, robust_mean)
  my.tr <- apply(Y.tr, 2, robust_mean, na.rm = TRUE)
  my.va <- apply(Y.va, 2, robust_mean, na.rm = TRUE)
  
  X.tr <- robust_scale(X.tr, center = mx.tr, scale = init.obj$sdx)
  X.va <- robust_scale(X.va, center = mx.va, scale = init.obj$sdx)
  Y.tr <- robust_scale(Y.tr, center = my.tr, scale = init.obj$sdy)
  Y.va <- robust_scale(Y.va, center = my.va, scale = init.obj$sdy)
  
  Z.tr <- Y.tr; Z.tr[is.na(Z.tr)] <- 0
  Z.va <- Y.va; Z.va[is.na(Z.va)] <- 0
  
  info <- list()
  info$n <- n.tr; info$p <- p; info$q <- q
  info$xtx <- crossprod(X.tr); info$xtx <- make_positive_definite(info$xtx)
  info$til.xty <- crossprod(X.tr, Z.tr) / rho.mat.1
  
  xtx.va     <- crossprod(X.va); xtx.va <- make_positive_definite(xtx.va)
  til.xty.va <- crossprod(X.va, Z.va) / rho.mat.va.1
  til.ytx.va <- t(til.xty.va)
  til.yty.va <- crossprod(Z.va) / rho.mat.va.2; til.yty.va <- make_positive_definite(til.yty.va)
  
  ## ---- Warm-start path over unique lamB ----
  lamB.uniq <- unique(lamB.vec)
  B.init <- lapply(seq_along(lamB.uniq), function(x) matrix(0, p, q))
  Beta <- matrix(0, p, q)
  
  residual.cov <- (crossprod(Z.tr) / rho.mat.2) / (n.tr - 1)
  residual.cov <- make_positive_definite(residual.cov)
  
  lamTh.mat <- lamTh.vec[1] * init.obj$lamTh.pf
  lamTh.mat[lamTh.mat == 0] <- 1e-12
  diag(lamTh.mat) <- 1e-12
  
  Theta.out <- tryCatch({
    run_glasso(S = residual.cov, rho = lamTh.mat,
               thr = min(0.001, Theta.thr * 100),
               maxIt = max(1000, Theta.maxit / 10))
  }, error = function(e) {
    list(wi = diag(pmin(pmax(1/diag(residual.cov), eps), 1/eps)))
  })
  Theta <- make_symmetric(Theta.out$wi)
  
  for (i in seq_along(lamB.uniq)) {
    lamB.mat <- lamB.uniq[i] * init.obj$lamB.pf
    lamB.mat[lamB.mat == 0] <- 1e-12
    
    Beta <- updateBeta(Theta = Theta, B0 = Beta,
                       n = n.tr, xtx = info$xtx, xty = info$til.xty, lamB = lamB.mat,
                       eta = eta, tolin = min(0.001, Beta.thr * 10), 
                       maxitrin = max(1000, ceiling(Beta.maxit / 10)))$Bhat
    E.tr <- Y.tr - X.tr %*% Beta
    residual.cov <- getResCov(E.tr, n.tr, rho.mat.2)
    
    Theta.out <- tryCatch({
      run_glasso(S = residual.cov, rho = lamTh.mat, 
                 thr = min(0.001, Theta.thr * 100), 
                 maxIt = max(1000, Theta.maxit / 10))
    }, error = function(e) {
      list(wi = Theta)
    })
    Theta <- make_symmetric(Theta.out$wi)
    B.init[[i]] <- Beta
  }
  
  ## ---- Sequential training across the grid ----
  info.update <- list()
  info.update$B.init <- B.init[[1]]
  E.tr <- Y.tr - X.tr %*% info.update$B.init
  info.update$residual.cov <- getResCov(E.tr, n.tr, rho.mat.2)
  Beta.thr.rescale <- Beta.thr
  lamB.crt <- lamB.vec[1]
  lamTh.lb <- min(lamTh.vec)
  
  for (i in seq_along(lamTh.vec)) {
    # Update warm start if lamB changes
    if (lamB.vec[i] < lamB.crt) {
      info.update$B.init <- B.init[[which(lamB.uniq == lamB.vec[i])]]
      E.tr <- Y.tr - X.tr %*% info.update$B.init
      info.update$residual.cov <- getResCov(E.tr, n.tr, rho.mat.2)
      Beta.thr.rescale <- Beta.thr
    }
    
    info.update$B.init <- update.missoNet(
      lamTh = lamTh.vec[i], lamB = lamB.vec[i],
      Beta.maxit = Beta.maxit, Beta.thr = Beta.thr.rescale,
      Theta.maxit = Theta.maxit, Theta.thr = Theta.thr,
      verbose = 0, eps = eps, eta = eta, init.obj = init.obj,
      info = info, info.update = info.update, under.cv = TRUE
    )
    
    err.fold[i] <- getEvalErr(yty = til.yty.va, ytx = til.ytx.va,
                              xty = til.xty.va, xtx = xtx.va,
                              Beta = info.update$B.init, n = n.va)
    
    # Allocate memory only when needed
    if (is.null(Beta.warm.fold[[i]])) {
      Beta.warm.fold[[i]] <- info.update$B.init
    } else {
      Beta.warm.fold[[i]] <- info.update$B.init
    }
    
    lamB.crt <- lamB.vec[i]
    
    if (lamTh.vec[i] > lamTh.lb) {
      E.tr <- Y.tr - X.tr %*% info.update$B.init
      info.update$residual.cov <- getResCov(E.tr, n.tr, rho.mat.2)
      Beta.thr.rescale <- max(Beta.thr, Beta.thr * norm(info.update$B.init, "F"))
    }
  }
  
  return(list(err.fold = err.fold, Beta.warm.fold = Beta.warm.fold))
}


parWrapper2 <- function(X.tr, Y.tr, GoF, info, rho.mat.2, B.init, lambda.Beta,
                        lambda.Theta, Beta.maxit, Beta.thr, Theta.maxit, Theta.thr,
                        init.obj, eps, eta) {
  
  n <- nrow(X.tr); p <- ncol(X.tr); q <- ncol(Y.tr)
  
  GoF.vec.fold <- rep(0, length(lambda.Theta))
  Beta.warm.fold <- lapply(seq_along(lambda.Theta), function(x) matrix(0, p, q))
  # Initialize update information
  info.update <- list(
    B.init = B.init,
    residual.cov = getResCov(Y.tr - X.tr %*% B.init, n, rho.mat.2)
  )
  Beta.thr.rescale <- Beta.thr
  
  # Loop over Theta lambda values
  for (i in seq_along(lambda.Theta)) {
    # Update model
    update.obj <- update.missoNet(
      lamTh = lambda.Theta[i], lamB = lambda.Beta,
      Beta.maxit = Beta.maxit, Beta.thr = Beta.thr.rescale,
      Theta.maxit = Theta.maxit, Theta.thr = Theta.thr,
      verbose = 0, eps = eps, eta = eta, init.obj = init.obj,
      info = info, info.update = info.update, under.cv = FALSE
    )
    
    # Compute residuals and covariance
    E.tr <- Y.tr - X.tr %*% update.obj$Beta
    info.update$residual.cov <- getResCov(E.tr, n, rho.mat.2)
    
    # Compute GoF
    GoF.vec.fold[i] <- GoF_func(
      GoF = GoF, gamma = 0.5, n = n, p = p, q = q,
      Theta = update.obj$Theta, S = info.update$residual.cov, Beta = update.obj$Beta
    )
    
    # Update for next iteration
    info.update$B.init <- Beta.warm.fold[[i]] <- update.obj$Beta
    Beta.thr.rescale <- max(Beta.thr, Beta.thr * norm(update.obj$Beta, "F"))
  }
  
  return(list(GoF.vec.fold = GoF.vec.fold, Beta.warm.fold = Beta.warm.fold))
}

