% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qp_solver.R
\name{qp_solver_DEoptim}
\alias{qp_solver_DEoptim}
\title{Solve Quadratic Programming Problem using DEoptim}
\usage{
qp_solver_DEoptim(
  n,
  A,
  b,
  c,
  x_max = 1,
  print_message = FALSE,
  NP = 100,
  itermax = 100,
  ...
)
}
\arguments{
\item{n}{An integer representing the number of decision variables.}

\item{A}{A matrix representing the quadratic coefficients.}

\item{b}{A numeric vector representing the linear coefficients.}

\item{c}{A numeric scalar representing the constant term in the objective function.}

\item{x_max}{An integer representing the upper bound for the decision variables. Default is 1.}

\item{print_message}{A logical value indicating whether to print optimization details. Default is FALSE.}

\item{NP}{An integer specifying the population size for the DEoptim algorithm. Default is 50.}

\item{itermax}{An integer specifying the maximum number of iterations. Default is 100.}

\item{...}{Additional control parameters for \code{DEoptim}.}
}
\value{
A list containing:
\item{f_cd}{The optimal objective function value.}
\item{x_value}{The optimal values of the decision variables.}
}
\description{
This function solves a quadratic programming problem using the Differential Evolution optimization method from the \code{DEoptim} package.
}
\seealso{
\code{\link{qp_solver}}, \code{\link{qp_solver_GA}}, \code{\link{qp_solver_nloptr}}
}
