% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{Agent}
\alias{Agent}
\title{Agent: A General-Purpose LLM Agent}
\description{
The `Agent` class defines a modular LLM-based agent capable of responding to prompts using a defined role/instruction.
It wraps an OpenAI-compatible chat model via the [`ellmer`](https://github.com/llrs/ellmer) package.

Each agent maintains its own message history and unique identity.
}
\examples{

## ------------------------------------------------
## Method `Agent$new`
## ------------------------------------------------

  # An API KEY is required in order to invoke the Agent
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )

  polar_bear_researcher <- Agent$new(
    name = "POLAR BEAR RESEARCHER",
    instruction = paste0(
    "You are an expert in polar bears, ",
    "you task is to collect information about polar bears. Answer in 1 sentence max."
    ),
    llm_object = openai_4_1_mini
  )



## ------------------------------------------------
## Method `Agent$invoke`
## ------------------------------------------------

\dontrun{
# An API KEY is required in order to invoke the Agent
openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
)
agent <- Agent$new(
 name = "translator",
 instruction = "You are an Algerian citizen",
 llm_object = openai_4_1_mini
)
agent$invoke("Continue this sentence: 1 2 3 viva")
}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{The agent's name.}

\item{\code{instruction}}{The agent's role/system prompt.}

\item{\code{llm_object}}{The underlying `ellmer::chat_openai` object.}

\item{\code{messages}}{A list of past messages (system, user, assistant).}

\item{\code{agent_id}}{A UUID uniquely identifying the agent.}

\item{\code{model_provider}}{The name of the entity providing the model (eg. OpenAI)}

\item{\code{model_name}}{The name of the model to be used (eg. gpt-4.1-mini)}

\item{\code{broadcast_history}}{A list of all past broadcast interactions.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Agent-new}{\code{Agent$new()}}
\item \href{#method-Agent-invoke}{\code{Agent$invoke()}}
\item \href{#method-Agent-clone}{\code{Agent$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-new"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new Agent with a specific role/instruction.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$new(name, instruction, llm_object)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{A short identifier for the agent (e.g. `"translator"`).}

\item{\code{instruction}}{The system prompt that defines the agent's role.}

\item{\code{llm_object}}{The LLM object generate by ellmer (eg. output of ellmer::chat_openai)}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{  # An API KEY is required in order to invoke the Agent
  openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
  )

  polar_bear_researcher <- Agent$new(
    name = "POLAR BEAR RESEARCHER",
    instruction = paste0(
    "You are an expert in polar bears, ",
    "you task is to collect information about polar bears. Answer in 1 sentence max."
    ),
    llm_object = openai_4_1_mini
  )


}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-invoke"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-invoke}{}}}
\subsection{Method \code{invoke()}}{
Sends a user prompt to the agent and returns the assistant's response.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$invoke(prompt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prompt}}{A character string prompt for the agent to respond to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The LLM-generated response as a character string.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
# An API KEY is required in order to invoke the Agent
openai_4_1_mini <- ellmer::chat(
    name = "openai/gpt-4.1-mini",
    api_key = Sys.getenv("OPENAI_API_KEY"),
    echo = "none"
)
agent <- Agent$new(
 name = "translator",
 instruction = "You are an Algerian citizen",
 llm_object = openai_4_1_mini
)
agent$invoke("Continue this sentence: 1 2 3 viva")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Agent-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Agent-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Agent$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
