% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_loss.R
\name{weighted.loss}
\alias{weighted.loss}
\title{Weighted Loss Function}
\usage{
weighted.loss(x, y = NULL, w = NULL, na.rm = FALSE, method = "rmse")
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{an optional numeric vector. If \code{NULL}, \code{x} is compared against its weighted mean.}

\item{w}{a numeric vector of sample weights for each value in \code{x}.}

\item{na.rm}{logical. If \code{TRUE}, any \code{NA} and \code{NaN}s are removed from all input vectors before the calculation.}

\item{method}{the loss measure. One of "mse" (mean square error), "rmse" (root mean square error), "mae" (mean absolute error), or "medae" (median absolute error).}
}
\value{
\code{weighted.loss()} returns a single numeric value.
}
\description{
\code{weighted.loss()} computes various loss metrics (e.g., RMSE, MAE) between two numeric vectors, or for the deviations from the weighted mean of a numeric vector.
}
\examples{
# Calculate loss metrics between x and y with weights
weighted.loss(x = c(0, 10), y = c(0, 0), w = c(99, 1), method = "rmse")
weighted.loss(x = c(0, 10), y = c(0, 0), w = c(99, 1), method = "mae")
weighted.loss(x = c(0, 10), y = c(0, 0), w = c(99, 1), method = "medae")

# Verify uninterpreted variation ratio of a fitted MID model without weights
mid <- interpret(dist ~ speed, cars)
RSS <- weighted.loss(cars$dist, predict(mid, cars), method = "mse")
TSS <- weighted.loss(cars$dist, method = "mse")
RSS / TSS
mid$ratio

# Verify uninterpreted variation ratio of a fitted MID model with weights
w <- 1:nrow(cars)
mid <- interpret(dist ~ speed, cars, weights = w)
RSS <- weighted.loss(cars$dist, predict(mid, cars), w = w, method = "mse")
TSS <- weighted.loss(cars$dist, w = w, method = "mse")
RSS / TSS
mid$ratio
}
