% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotmarker}
\alias{plotmarker}
\title{plot the biomarker from the biomarker function with randomForest}
\usage{
plotmarker(
  x,
  level = "Genus",
  top = 30,
  rotate = FALSE,
  dot.size = 8,
  label.color = "black",
  label.size = 6
)
}
\arguments{
\item{x}{biomarker results from randomForest}

\item{level}{the bacteria level to display}

\item{top}{the number of important biomarker to draw}

\item{rotate}{TRUE/FALSE}

\item{dot.size}{size for the dot}

\item{label.color}{label color}

\item{label.size}{label size}
}
\value{
ggplot2 object
}
\description{
plot the biomarker from the biomarker function with randomForest
}
\examples{
\donttest{
data("Physeq")
res <- biomarker(physeq,group="group")
plotmarker(res,level="Genus")
}
}
\author{
Kai Guo
}
