% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micomp.R
\name{assumptions.micomp}
\alias{assumptions.micomp}
\title{Get assumptions for parametric tests performed on each comparisons}
\usage{
\method{assumptions}{micomp}(obj)
}
\arguments{
\item{obj}{Object of class \code{\link{micomp}}.}
}
\value{
Object of class \code{assumptions_micomp} containing the
assumptions for parametric tests performed for the multiple comparisons held
by the \code{mcmp} object. This object is a multi-dimensional list of
\code{assumptions_cmpoutput} objects. Rows are associated with individual
outputs, while columns are associated with separate comparisons.
}
\description{
Get assumptions for parametric tests performed on multiple comparisons (i.e.
from objects of class \code{\link{micomp}}).
}
\examples{

# Create a micomp object, use provided dataset
mic <- micomp(6, 0.8,
              list(list(name = "NLOKvsJEXOK", grpout = pphpc_ok),
                   list(name = "NLOKvsJEXNOSHUFF", grpout = pphpc_noshuff),
                   list(name = "NLOKvsJEXDIFF", grpout = pphpc_diff)))

# Create an object containing the statistic tests evaluating the assumptions
# of the comparisons performed in the mic object
a <- assumptions(mic)

}
