% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEcollect.R
\name{metaGE.collect}
\alias{metaGE.collect}
\title{Collect the results of GWAS data from different files}
\usage{
metaGE.collect(
  FileNames,
  VariableNames,
  MinFreq = 0,
  DropDuplicates = TRUE,
  Verbose = FALSE,
  NA.rmv = TRUE
)
}
\arguments{
\item{FileNames}{A list containing the file paths to merge (one trait only) or a list of such lists}

\item{VariableNames}{A named list containing the column names in the original files corresponding
to the variables : MARKER, CHR, POS, EFFECT, PVAL (optional: FREQ, ALLELE0, ALLELE1) ; or a list of such lists.}

\item{MinFreq}{A numeric value allowing to filter markers based on the maf. (optional)}

\item{DropDuplicates}{A boolean indicating whether duplicate markers should be removed or not. (\code{TRUE} by default)}

\item{Verbose}{A boolean indicating whether progression messages should be printed or not. (\code{FALSE} by default)}

\item{NA.rmv}{A boolean indicating if the \code{NA} should be removed or not (\code{TRUE} by default)}
}
\value{
A list with the following elements:
\tabular{ll}{
\code{Data} \tab A tibble containing all the columns of interest of all the files from FileNames.\cr
\code{RemovedMarkers} \tab Same kind of tibble, but containing the markers that have been removed
due to unclear allele coding, maf filtering or duplicates dropping.
}
}
\description{
This function merges files containing the summary statistics of GWAS in different environments (one file per environment).
}
\details{
Each file MUST contain the variables below:
\itemize{
\item MARKER: the marker name
\item CHR: the chromosome
\item POS: the position of the marker
\item EFFECT: the mean effect of the marker
\item PVAL: the pvalue
}

Each file might contain the variables:
\itemize{
\item FREQ: MAF
\item ALLELE0: Allele coding for allele 0
\item ALLELE1: Allele coding for allele 1
}
}
\examples{
require(dplyr)
require(tibble)
require(stringr)
RepData <- system.file("extdata", package = "metaGE")
# Get the complete list of association files
File.list <- list.files(RepData ,full.names = TRUE) \%>\%
            tibble(Names = .) \%>\%
            mutate(ShortNames = Names \%>\%
                  str_remove(pattern = paste0(RepData,"/")) \%>\%
                  str_remove(pattern = "_DF.txt"))  \%>\%
            select(ShortNames,Names) \%>\%
            deframe
###Build the dataset
## First provide the list of variable names
Names.list <- list(MARKER="Marker_Name",
                  CHR="Chromosome",
                  POS="Marker_Position",
                  FREQ="Maf",
                  EFFECT="SNP_Weight",
                  PVAL="Pvalue",
                  ALLELE0="Allele1",
                  ALLELE1="Allele2")

MinFreq <- 0.07

## Now collect
metaData <- metaGE.collect(File.list, Names.list,MinFreq = MinFreq)
}
