% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mnet_calc_vwc.R
\name{mnet_calc_vwc}
\alias{mnet_calc_vwc}
\title{Calculate soil volumteric water content for Oklahoma Mesonet data}
\usage{
mnet_calc_vwc(data, site_info = NULL)
}
\arguments{
\item{data}{a data frame that contains a column of Mesonet station
identifier codes (i.e. STID) and columns for delta-T temperature change
data (i.e. TR05, TR25, TR60, TR75)}

\item{site_info}{a data frame with site and soil information for each
Oklahoma Mesonet station as returned by \link[mesonet]{mnet_site_info}. If
NULL, \link[mesonet]{mnet_site_info} will be used to download this
information internally}
}
\value{
a data frame containing new columns with volumetric water content for
 each column of delta-T temperature change data.
}
\description{
Calculate soil volumetric water content from delta-T soil temperature change data
 from the Oklahoma Mesonet using \link[mesonet]{mnet_calc_mp} to calculate
 matric potential and \link[mesonet]{mnet_van_genuchten} to calculate the
 corresponding volumetric water content using parameters provided by
 \link[mesonet]{mnet_site_info}.
}
\examples{

\dontshow{
  mesonet_cache_dir <- mnet_test_cache(site_info = TRUE)
  previous_options <- options(.mesonet_cache = mesonet_cache_dir)
}

# Create example dataset
mesonet_data <- data.frame(STID = "ACME", DATE = as.POSIXct("2025-01-01"),
                           TR05 = 3.17, TR25 = 2.17, TR60 = 2.0, TR75 = 1.0)

mnet_calc_vwc(mesonet_data)

\dontshow{
  unlink(mesonet_cache_dir, recursive = TRUE)
  options(previous_options)
}

}
