% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mclink.R
\name{mclink}
\alias{mclink}
\title{Metabolic Pathway Coverage Analysis}
\usage{
mclink(
  ref = NULL,
  data = NULL,
  table_feature = "completeness",
  plus_scale_method = "mean",
  comma_scale_method = "max",
  out_dir = NULL,
  split_by_pathway = FALSE
)
}
\arguments{
\item{ref}{Pathway information data frame. When \code{NULL} (default),
uses the built-in \code{\link{KO_pathway_ref}} dataset. Must contain the
same columns as the built-in dataset if providing custom data.}

\item{data}{Sample KO abundance data frame. When \code{NULL} (default),
uses the built-in \code{\link{KO_Sample_wide}} dataset.}

\item{table_feature}{Analysis type, either:
\itemize{
\item "completeness" (binary presence/absence, default)
\item "abundance" (weighted by KO abundance)
}}

\item{plus_scale_method}{Scaling method for plus-separated KOs (subunits/complexes):
\itemize{
\item "mean" - Moderate approach (default)
\item "min" - Rigorous/conservative estimate
\item "max" - Liberal estimate
}}

\item{comma_scale_method}{Scaling method for comma-separated KOs (isoforms/alternatives):
\itemize{
\item "max" - For completeness analysis (default)
\item "sum" - For abundance analysis
}}

\item{out_dir}{Output directory path. If \code{NULL} (default), results are only
returned as R objects without writing files.}

\item{split_by_pathway}{Logical. If \code{TRUE}, splits results by pathway/module.
Requires non-NULL \code{out_dir}. Default: \code{FALSE}.}
}
\value{
A list containing:
\itemize{
\item coverage - Data frame with pathway coverage metrics
\item detected_KOs - List of detected KOs per pathway/module
\item log - log of the analysis process
}

If \code{out_dir} is specified, results are also written as TSV files.
}
\description{
Analyzes metabolic pathway completeness/abundance from (meta)genome KO presence/abundance data.
Can use either built-in KEGG datasets or user-provided data frames. Output includes pathway coverage
metrics and detected KOs in each pathway/module.
}
\examples{
data(KO_pathway_ref)
data(KO_Sample_wide)
selected_modules <- c("M00176","M00165","M00173","M00374","M00375","M00376","M00377")
KO_pathway_ref_selected <- KO_pathway_ref[KO_pathway_ref$Module_Entry \%in\% selected_modules, ]
mc_list =
  mclink(ref = KO_pathway_ref_selected,
         data = KO_Sample_wide,
         table_feature = "completeness",
         plus_scale_method = "min",
         comma_scale_method = "max")
mc_coverage = mc_list[["coverage"]]
mc_detected_KOs = mc_list[["detected_KOs"]]
mc_log = mc_list[["log"]]
print(head(mc_coverage))
}
