% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_wrapper_irving}
\alias{cpp_wrapper_irving}
\title{Computes a stable roommate matching}
\usage{
cpp_wrapper_irving(pref)
}
\arguments{
\item{pref}{is a matrix with the preference order of each individual in the
market. If there are \code{n} individuals, then this matrix will be of
dimension \code{n-1} by \code{n}. The \code{i,j}th element refers to
\code{j}'s \code{i}th most favorite partner. Preference orders must be
specified using C++ indexing (starting at 0). The matrix \code{pref} must
be of dimension \code{n-1} by \code{n}.}
}
\value{
A vector of length \code{n} corresponding to the matchings that were
  formed (using C++ indexing). E.g. if the \code{4}th element of this vector
  is \code{0} then individual \code{4} was matched with individual \code{1}.
  If no stable matching exists, then this function returns a vector of
  zeros.
 @export
}
\description{
This is the C++ wrapper for the stable roommate problem. Users should not
call this function directly, but instead use
\code{\link{roommate}}.
}
