% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat_2_and_3.R
\docType{data}
\name{data_med_mod_serial}
\alias{data_med_mod_serial}
\title{Sample Dataset: Serial
Mediation with Two Moderators}
\format{
A data frame with 100 rows
and 8 variables:
\describe{
\item{x}{Predictor. Numeric.}
\item{w1}{Moderator 1. Numeric.}
\item{w2}{Moderator 2. Numeric.}
\item{m1}{Mediator 1. Numeric.}
\item{m2}{Mediator 2. Numeric.}
\item{y}{Outcome variable. Numeric.}
\item{c1}{Control variable. Numeric.}
\item{c2}{Control variable. Numeric.}
}
}
\usage{
data_med_mod_serial
}
\description{
A simple mediation model
with a-path and b2-path moderated.
}
\examples{
library(lavaan)
data(data_med_mod_serial)
data_med_mod_serial$xw1 <-
 data_med_mod_serial$x *
 data_med_mod_serial$w1
data_med_mod_serial$m2w2 <-
 data_med_mod_serial$m2 *
 data_med_mod_serial$w2
mod <-
"
m1 ~ a * x + w1 + da1 * xw1 + c1 + c2
m2 ~ b1 * m1 + x + w1 + c1 + c2
y ~ b2 * m2 + m1 + x + w1 + w2 + db2 * m2w2 + c1 + c2
w1 ~~ v_w1 * w1
w1 ~ m_w1 * 1
w2 ~~ v_w2 * w2
w2 ~ m_w2 * 1
ab1b2 := a * b1 * b2
ab1b2_lolo := (a + da1 * (m_w1 - sqrt(v_w1))) * b1 * (b2 + db2 * (m_w2 - sqrt(v_w2)))
ab1b2_lohi := (a + da1 * (m_w1 - sqrt(v_w1))) * b1 * (b2 + db2 * (m_w2 + sqrt(v_w2)))
ab1b2_hilo := (a + da1 * (m_w1 + sqrt(v_w1))) * b1 * (b2 + db2 * (m_w2 - sqrt(v_w2)))
ab1b2_hihi := (a + da1 * (m_w1 + sqrt(v_w1))) * b1 * (b2 + db2 * (m_w2 + sqrt(v_w2)))
"
fit <- sem(mod, data_med_mod_serial,
           meanstructure = TRUE, fixed.x = FALSE)
parameterEstimates(fit)[c(1, 3, 6, 11, 16, 49:53), ]
}
\keyword{datasets}
