% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_dimensions.R
\name{compare_overlap}
\alias{compare_overlap}
\title{Compare the overlap between datasets in 'many' datacubes}
\usage{
compare_overlap(datacube, dataset = "all", key = NULL)
}
\arguments{
\item{datacube}{A datacube from one of the many packages.}

\item{dataset}{A dataset in a datacube from one of the many packages.
By default "all".
That is, all datasets in the datacube are used.}

\item{key}{A variable key to join datasets.
'manyID' by default.}
}
\value{
\code{compare_overlap()} returns a tibble with information about each dataset
and the number of overlapping observations.
}
\description{
Compare the overlap between datasets in 'many' datacubes
}
\details{
\code{compare_overlap()} compares the overlap between "key" observations
in each dataset in a 'many' datacube.
}
\examples{
\donttest{
compare_overlap(emperors, key = "ID")
plot(compare_overlap(emperors, key = "ID"))
}
}
\seealso{
Other compare_: 
\code{\link{compare_categories}()},
\code{\link{compare_dimensions}()},
\code{\link{compare_missing}()}
}
\concept{compare_}
