% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipe.R
\name{\%<>\%}
\alias{\%<>\%}
\title{Assignment pipe}
\usage{
lhs \%<>\% rhs
}
\arguments{
\item{lhs}{An object which serves both as the initial value and as target.}

\item{rhs}{a function call using the magrittr semantics.}
}
\description{
Pipe an object forward into a function or call expression and update the
\code{lhs} object with the resulting value.
}
\details{
The assignment pipe, \code{\%<>\%}, is used to
update a value by first piping it into one or more \code{rhs} expressions, and
then assigning the result. For example, \code{some_object \%<>\% 
foo \%>\% bar} is equivalent to \code{some_object <- some_object \%>\% foo
\%>\% bar}. It must be the first pipe-operator in a chain, but otherwise it
works like \code{\link{\%>\%}}.
}
\examples{
iris$Sepal.Length \%<>\% sqrt

x <- rnorm(100)

x \%<>\% abs \%>\% sort

is_weekend <- function(day)
{
   # day could be e.g. character a valid representation
   day \%<>\% as.Date
   
   result <- day \%>\% format("\%u") \%>\% as.numeric \%>\% is_greater_than(5)
   
   if (result)
     message(day \%>\% paste("is a weekend!"))
   else
     message(day \%>\% paste("is not a weekend!"))
   
   invisible(result)
}

}
\seealso{
\code{\link{\%>\%}}, \code{\link{\%T>\%}}, \code{\link{\%$\%}}
}
