% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/examinee_updaters.R
\name{updatePhase}
\alias{updatePhase}
\title{Update the current phase of an examinee object}
\usage{
updatePhase(examinee_object, assessment_structure)
}
\arguments{
\item{examinee_object}{an \code{\linkS4class{examinee}} object.}

\item{assessment_structure}{an \code{\linkS4class{assessment_structure}} object.}
}
\value{
an \code{\linkS4class{examinee}} object with its \code{current_phase} slot updated.
}
\description{
\code{\link{updatePhase}} is a function for updating \code{\linkS4class{examinee}} objects after completing a module.
\code{\link{updatePhase}} updates the phase by calling \code{\link{changePhase}}.
}
\examples{
## assessment uses two phases

examinee <- examinee_list_math[[1]]
examinee@current_phase ## P1

examinee <- updatePhase(examinee, assessment_structure_math)
examinee@current_phase ## P2

examinee <- updatePhase(examinee, assessment_structure_math)
examinee@current_phase ## P1

}
