% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks-tfevents.R
\name{luz_callback_tfevents}
\alias{luz_callback_tfevents}
\title{tfevents callback}
\usage{
luz_callback_tfevents(logdir = "logs", histograms = FALSE, ...)
}
\arguments{
\item{logdir}{A directory to where log will be written to.}

\item{histograms}{A boolean specifying if histograms of model weights should
be logged. It can also be a character vector specifying the name of the parameters
that should be logged (names are the same as \code{names(model$parameters)}).}

\item{...}{Currently not used. For future expansion.}
}
\description{
Logs metrics and other model information in the tfevents file format.
Assuming tensorboard is installed, result can be visualized with
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{tensorboard --logdir=logs
}\if{html}{\out{</div>}}
}
\examples{
if (torch::torch_is_installed()) {
library(torch)
x <- torch_randn(1000, 10)
y <- torch_randn(1000, 1)

model <- nn_linear \%>\%
  setup(loss = nnf_mse_loss, optimizer = optim_adam) \%>\%
  set_hparams(in_features = 10, out_features = 1) \%>\%
  set_opt_hparams(lr = 1e-4)

tmp <- tempfile()

model \%>\% fit(list(x, y), valid_data = 0.2, callbacks = list(
  luz_callback_tfevents(tmp, histograms = TRUE)
))
}
}
