% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{phregr}
\alias{phregr}
\title{Proportional Hazards Regression Models}
\usage{
phregr(
  data,
  rep = "",
  stratum = "",
  time = "time",
  time2 = "",
  event = "event",
  covariates = "",
  weight = "",
  offset = "",
  id = "",
  ties = "efron",
  init = NA_real_,
  robust = FALSE,
  est_basehaz = TRUE,
  est_resid = TRUE,
  firth = FALSE,
  plci = FALSE,
  alpha = 0.05,
  maxiter = 50,
  eps = 1e-09
)
}
\arguments{
\item{data}{The input data frame that contains the following variables:
\itemize{
\item \code{rep}: The replication for by-group processing.
\item \code{stratum}: The stratum.
\item \code{time}: The follow-up time for right censored data, or
the left end of each interval for counting process data.
\item \code{time2}: The right end of each interval for counting process
data. Intervals are assumed to be open on the left
and closed on the right, and event indicates whether an event
occurred at the right end of each interval.
\item \code{event}: The event indicator, 1=event, 0=no event.
\item \code{covariates}: The values of baseline covariates (and
time-dependent covariates in each interval for counting
process data).
\item \code{weight}: The weight for each observation.
\item \code{offset}: The offset for each observation.
\item \code{id}: The optional subject ID for counting process data
with time-dependent covariates.
}}

\item{rep}{The name(s) of the replication variable(s) in the input data.}

\item{stratum}{The name(s) of the stratum variable(s) in the input data.}

\item{time}{The name of the time variable or the left end of each
interval for counting process data in the input data.}

\item{time2}{The name of the right end of each interval for counting
process data in the input data.}

\item{event}{The name of the event variable in the input data.}

\item{covariates}{The vector of names of baseline and time-dependent
covariates in the input data.}

\item{weight}{The name of the weight variable in the input data.}

\item{offset}{The name of the offset variable in the input data.}

\item{id}{The name of the id variable in the input data.}

\item{ties}{The method for handling ties, either "breslow" or
"efron" (default).}

\item{init}{The vector of initial values. Defaults to zero for all
variables.}

\item{robust}{Whether a robust sandwich variance estimate should be
computed. In the presence of the id variable, the score residuals
will be aggregated for each id when computing the robust sandwich
variance estimate.}

\item{est_basehaz}{Whether to estimate the baseline hazards.
Defaults to \code{TRUE}.}

\item{est_resid}{Whether to estimate the martingale residuals.
Defaults to \code{TRUE}.}

\item{firth}{Whether to use Firth’s penalized likelihood method.
Defaults to \code{FALSE}.}

\item{plci}{Whether to obtain profile likelihood confidence interval.}

\item{alpha}{The two-sided significance level.}

\item{maxiter}{The maximum number of iterations.}

\item{eps}{The tolerance to declare convergence.}
}
\value{
A list with the following components:
\itemize{
\item \code{sumstat}: The data frame of summary statistics of model fit
with the following variables:
\itemize{
\item \code{n}: The number of observations.
\item \code{nevents}: The number of events.
\item \code{loglik0}: The (penalized) log-likelihood under null.
\item \code{loglik1}: The maximum (penalized) log-likelihood.
\item \code{scoretest}: The score test statistic.
\item \code{niter}: The number of Newton-Raphson iterations.
\item \code{ties}: The method for handling ties, either "breslow" or
"efron".
\item \code{p}: The number of columns of the Cox model design matrix.
\item \code{robust}: Whether to use the robust variance estimate.
\item \code{firth}: Whether to use Firth's penalized likelihood method.
\item \code{fail}: Whether the model fails to converge.
\item \code{loglik0_unpenalized}: The unpenalized log-likelihood under null.
\item \code{loglik1_unpenalized}: The maximum unpenalized log-likelihood.
\item \code{rep}: The replication.
}
\item \code{parest}: The data frame of parameter estimates with the
following variables:
\itemize{
\item \code{param}: The name of the covariate for the parameter estimate.
\item \code{beta}: The log hazard ratio estimate.
\item \code{sebeta}: The standard error of log hazard ratio estimate.
\item \code{z}: The Wald test statistic for log hazard ratio.
\item \code{expbeta}: The hazard ratio estimate.
\item \code{vbeta}: The covariance matrix for parameter estimates.
\item \code{lower}: The lower limit of confidence interval.
\item \code{upper}: The upper limit of confidence interval.
\item \code{p}: The p-value from the chi-square test.
\item \code{method}: The method to compute the confidence interval and
p-value.
\item \code{sebeta_naive}: The naive standard error of log hazard ratio
estimate if robust variance is requested.
\item \code{vbeta_naive}: The naive covariance matrix for parameter
estimates if robust variance is requested.
\item \code{rep}: The replication.
}
\item \code{basehaz}: The data frame of baseline hazards with the following
variables (if est_basehaz is TRUE):
\itemize{
\item \code{time}: The observed event time.
\item \code{nrisk}: The number of patients at risk at the time point.
\item \code{nevent}: The number of events at the time point.
\item \code{haz}: The baseline hazard at the time point.
\item \code{varhaz}: The variance of the baseline hazard at the time point
assuming the parameter beta is known.
\item \code{gradhaz}: The gradient of the baseline hazard with respect to
beta at the time point (in the presence of covariates).
\item \code{stratum}: The stratum.
\item \code{rep}: The replication.
}
\item \code{residuals}: The martingale residuals.
\item \code{p}: The number of parameters.
\item \code{param}: The parameter names.
\item \code{beta}: The parameter estimate.
\item \code{vbeta}: The covariance matrix for parameter estimates.
\item \code{vbeta_naive}: The naive covariance matrix for parameter estimates.
\item \code{terms}: The terms object.
\item \code{xlevels}: A record of the levels of the factors used in fitting.
\item \code{data}: The input data.
\item \code{rep}: The name(s) of the replication variable(s).
\item \code{stratum}: The name(s) of the stratum variable(s).
\item \code{time}: The name of the time varaible.
\item \code{time2}: The name of the time2 variable.
\item \code{event}: The name of the event variable.
\item \code{covariates}: The names of baseline covariates.
\item \code{weight}: The name of the weight variable.
\item \code{offset}: The name of the offset variable.
\item \code{id}: The name of the id variable.
\item \code{ties}: The method for handling ties.
\item \code{robust}: Whether a robust sandwich variance estimate should be
computed.
\item \code{est_basehaz}: Whether to estimate the baseline hazards.
\item \code{est_resid}: Whether to estimate the martingale residuals.
\item \code{firth}: Whether to use Firth's penalized likelihood method.
\item \code{plci}: Whether to obtain profile likelihood confidence interval.
\item \code{alpha}: The two-sided significance level.
}
}
\description{
Obtains the hazard ratio estimates from the proportional
hazards regression model with right censored or counting process data.
}
\examples{

library(dplyr)

# Example 1 with right-censored data
(fit1 <- phregr(
  data = rawdata \%>\% mutate(treat = 1*(treatmentGroup == 1)),
  rep = "iterationNumber", stratum = "stratum",
  time = "timeUnderObservation", event = "event",
  covariates = "treat", est_basehaz = FALSE, est_resid = FALSE))

# Example 2 with counting process data and robust variance estimate
(fit2 <- phregr(
  data = heart \%>\% mutate(rx = as.numeric(transplant) - 1),
  time = "start", time2 = "stop", event = "event",
  covariates = c("rx", "age"), id = "id",
  robust = TRUE, est_basehaz = TRUE, est_resid = TRUE))

}
\references{
Per K. Anderson and Richard D. Gill.
Cox's regression model for counting processes, a large sample study.
Annals of Statistics 1982; 10:1100-1120.

Terry M. Therneau and Patricia M. Grambsch.
Modeling Survival Data: Extending the Cox Model.
Springer-Verlag, 2000.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
