% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDesignProportions.R
\name{getDesignOneMultinom}
\alias{getDesignOneMultinom}
\title{Power and Sample Size for One-Sample Multinomial Response}
\usage{
getDesignOneMultinom(
  beta = NA_real_,
  n = NA_real_,
  ncats = NA_integer_,
  piH0 = NA_real_,
  pi = NA_real_,
  rounding = TRUE,
  alpha = 0.05
)
}
\arguments{
\item{beta}{The type II error.}

\item{n}{The total sample size.}

\item{ncats}{The number of categories of the multinomial response.}

\item{piH0}{The prevalence of each category under the null hypothesis.
Only need to provide the values for the first \code{ncats-1}
categories.}

\item{pi}{The prevalence of each category. Only need to provide the
values for the first \code{ncats-1} categories.}

\item{rounding}{Whether to round up sample size. Defaults to 1 for
sample size rounding.}

\item{alpha}{The two-sided significance level. Defaults to 0.05.}
}
\value{
An S3 class \code{designOneMultinom} object with the following
components:
\itemize{
\item \code{power}: The power to reject the null hypothesis.
\item \code{alpha}: The two-sided significance level.
\item \code{n}: The maximum number of subjects.
\item \code{ncats}: The number of categories of the multinomial response.
\item \code{piH0}: The prevalence of each category under the null hypothesis.
\item \code{pi}: The prevalence of each category.
\item \code{effectsize}: The effect size for the chi-square test.
\item \code{rounding}: Whether to round up sample size.
}
}
\description{
Obtains the power given sample size or obtains the sample
size given power for one-sample multinomial response.
}
\details{
A single-arm multinomial response design is used to test whether the
prevalence of each category is different from the null hypothesis
prevalence.
The null hypothesis is that the prevalence of each category
is equal to \eqn{\pi_{0i}}, while the alternative hypothesis is that
the prevalence of each category is equal to \eqn{\pi_i}, for
\eqn{i=1,\ldots,C}, where \eqn{C} is the number of categories.

The sample size is calculated based on the chi-square test for
multinomial response. The test statistic is given by
\deqn{X^2 = \sum_{i=1}^{C} \frac{(n_i - n\pi_{0i})^2}{n\pi_{0i}}}
where \eqn{n_i} is the number of subjects in category \eqn{i}, and
\eqn{n} is the total sample size.
\itemize{
\item Under the null hypothesis, \eqn{X^2} follows a chi-square distribution
with \eqn{C-1} degrees of freedom.
\item Under the alternative hypothesis, \eqn{X^2} follows a non-central
chi-square distribution with non-centrality parameter
\deqn{\lambda = n \sum_{i=1}^{C} \frac{(\pi_i - \pi_{0i})^2}{\pi_{0i}}}
}

The sample size is chosen such that the power to reject the null
hypothesis is at least \eqn{1-\beta} for a given
significance level \eqn{\alpha}.
}
\examples{

(design1 <- getDesignOneMultinom(
  beta = 0.1, ncats = 3, piH0 = c(0.25, 0.25),
  pi = c(0.3, 0.4), alpha = 0.05))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
