% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loon_ggplot.R
\name{loon.ggplot}
\alias{loon.ggplot}
\alias{loon.ggplot.gg}
\alias{loon.ggplot.loon}
\alias{loon.ggplot.zenplot}
\alias{loon.ggplot.l_ggplot}
\title{loon.ggplot}
\usage{
loon.ggplot(x, ...)

\method{loon.ggplot}{gg}(x, ...)

\method{loon.ggplot}{loon}(x, ...)

\method{loon.ggplot}{zenplot}(x, ...)

\method{loon.ggplot}{l_ggplot}(x, ...)
}
\arguments{
\item{x}{A \code{loon} widget, a \code{ggplot} object or a \code{l_ggplot} object.}

\item{...}{arguments used in either \code{loon2ggplot()} or \code{ggplot2loon()}}
}
\value{
If the input is a \code{ggplot} object, the output would be a \code{loon} widget; conversely, if the
input is a \code{loon} widget, then it returns a \code{ggplot} object. If it is a \code{l_ggplot} object,
\code{loon.ggplot} helps to return a \code{loon} widget.
}
\description{
A bridge between \code{loon} widgets and \code{gg} objects. It can take either a \code{loon} widget,
a \code{gg} object (\code{ggplot}, \code{GGally::ggmatrix}) or
a \code{l_ggplot} object, then create a corresponding \code{gg} (or \code{loon}) graphics.
}
\examples{

if(interactive()) {
######### loon --> gg #########
  # loon 3D plot
  l <- with(quakes,
    l_plot3D(long, lat, depth, linkingGroup = "quakes")
  )
  # equivalent to `loon2ggplot(l)`
  g <- loon.ggplot(l)
  g # a ggplot object

######### gg --> loon #########

  # ggplot histogram
  g <- ggplot(iris, mapping = aes(Sepal.Length, fill = Species)) +
    geom_histogram()
  # equivalent to `ggplot2loon(g)`
  l <- loon.ggplot(g)
  l # a loon widget

######### l_ggplot #########
  p <- l_ggplot(mpg, aes(displ, fill = factor(cyl))) +
       geom_histogram()
  class(p)
  # Function `print.l_ggplot` is called automatically
  p
  # Function `loon.ggplot` helps to return a loon widget
  q <- loon.ggplot(p)
  q
}
}
\seealso{
Richer examples are in \code{\link{loon2ggplot}}, \code{\link{ggplot2loon}}, \code{\link{l_ggplot}}
}
