% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonparametric.R
\name{turnbull_intervals}
\alias{turnbull_intervals}
\title{Turnbull's sets}
\usage{
turnbull_intervals(time, time2 = NULL, status, ltrunc = NULL, rtrunc = NULL)
}
\arguments{
\item{time}{excess time of the event of follow-up time, depending on the value of event}

\item{time2}{ending excess time of the interval for interval censored data only.}

\item{ltrunc}{lower truncation limit, default to \code{NULL}}

\item{rtrunc}{upper truncation limit, default to \code{NULL}}
}
\value{
a matrix with two columns containing the \code{left} and \code{right} bounds Of Turnbull sets
}
\description{
Given censoring and truncation set,
compute the regions of the real line that
get positive mass and over which the distribution
function is well-defined.
}
\note{
The function adds the square root of the machine tolerance to left bounds of interval censored data
so they are open.
}
\references{
Frydman, H. (1994). \emph{A Note on Nonparametric Estimation of the Distribution Function from Interval-Censored and Truncated Observations}, Journal of the Royal Statistical Society. Series B (Methodological) \bold{56}(1), 71-74.

Turnbull, B. W. (1976). \emph{The Empirical Distribution Function with Arbitrarily Grouped, Censored and Truncated Data.} Journal of the Royal Statistical Society, Series B \bold{38}, 290-295.
}
\keyword{internal}
