% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{pextgp}
\alias{pextgp}
\title{Distribution function of the extended generalized Pareto distribution}
\usage{
pextgp(q, scale = 1, shape1 = 0, shape2 = 0, lower.tail = TRUE, log.p = FALSE)
}
\arguments{
\item{q}{vector of quantiles.}

\item{scale}{scale parameter, strictly positive.}

\item{shape1}{positive shape parameter \eqn{\beta}; model defaults to generalized Pareto when it equals zero.}

\item{shape2}{shape parameter \eqn{\gamma}; model reduces to Gompertz when \code{shape2=0}.}

\item{lower.tail}{logical; if \code{TRUE} (default), the lower tail probability \eqn{\Pr(X \leq x)} is returned.}

\item{log.p}{logical; if \code{FALSE} (default), values are returned on the probability scale.}
}
\value{
a vector of (log)-probabilities of the same length as \code{q}
}
\description{
Distribution function of the extended generalized Pareto distribution
}
\keyword{internal}
