% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{log_separator}
\alias{log_separator}
\title{Logs a long line to stand out from the console}
\usage{
log_separator(
  level = INFO,
  namespace = NA_character_,
  separator = "=",
  width = 80,
  .logcall = sys.call(),
  .topcall = sys.call(-1),
  .topenv = parent.frame(),
  .timestamp = Sys.time()
)
}
\arguments{
\item{level}{log level, see \code{\link[=log_levels]{log_levels()}} for more details}

\item{namespace}{string referring to the \code{logger} environment /
config to be used to override the target of the message record to
be used instead of the default namespace, which is defined by the
R package name from which the logger was called, and falls back
to a common, global namespace.}

\item{separator}{character to be used as a separator}

\item{width}{max width of message -- longer text will be wrapped into multiple lines}

\item{.logcall}{the logging call being evaluated (useful in
formatters and layouts when you want to have access to the raw,
unevaluated R expression)}

\item{.topcall}{R expression from which the logging function was
called (useful in formatters and layouts to extract the calling
function's name or arguments)}

\item{.topenv}{original frame of the \code{.topcall} calling function
where the formatter function will be evaluated and that is used
to look up the \code{namespace} as well via \code{logger:::top_env_name}}

\item{.timestamp}{The time the logging occured. Defaults to the current time
but may be overwritten if the logging is delayed from the time it happend}
}
\description{
Logs a long line to stand out from the console
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
log_separator()
log_separator(ERROR, separator = "!", width = 60)
log_separator(ERROR, separator = "!", width = 100)
logger <- layout_glue_generator(format = "{node}/{pid}/{namespace}/{fn} {time} {level}: {msg}")
log_layout(logger)
log_separator(ERROR, separator = "!", width = 100)
log_layout(layout_blank)
log_separator(ERROR, separator = "!", width = 80)
\dontshow{logger:::namespaces_set(old)}
}
\seealso{
\code{\link[=log_with_separator]{log_with_separator()}}
}
