% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmtp_survival.R
\name{lmtp_survival}
\alias{lmtp_survival}
\title{LMTP Survival Curve Estimator}
\usage{
lmtp_survival(
  data,
  trt,
  outcomes,
  baseline = NULL,
  time_vary = NULL,
  cens = NULL,
  compete = NULL,
  shift = NULL,
  shifted = NULL,
  estimator = c("lmtp_tmle", "lmtp_sdr"),
  k = Inf,
  mtp = TRUE,
  id = NULL,
  learners_outcome = "SL.glm",
  learners_trt = "SL.glm",
  folds = 10,
  weights = NULL,
  control = lmtp_control()
)
}
\arguments{
\item{data}{[\code{data.frame}]\cr
A \code{data.frame} in wide format containing all necessary variables
for the estimation problem. Must not be a \code{data.table}.}

\item{trt}{[\code{character}] or [\code{list}]\cr
A vector containing the column names of treatment variables ordered by time.
Or, a list of vectors, the same length as the number of time points of observation.
Vectors should contain column names for the treatment variables at each time point. The list
should be ordered following the time ordering of the model.}

\item{outcomes}{[\code{character}]\cr
A vector containing the columns names of intermediate outcome variables and the final
outcome variable ordered by time. Only numeric values are allowed. Variables should be coded as 0 and 1.}

\item{baseline}{[\code{character}]\cr
An optional vector containing the column names of baseline covariates to be
included for adjustment at every time point.}

\item{time_vary}{[\code{list}]\cr
A list the same length as the number of time points of observation with
the column names for new time-varying covariates introduced at each time point. The list
should be ordered following the time ordering of the model.}

\item{cens}{[\code{character}]\cr
An optional vector of column names of censoring indicators the same
length as the number of time points of observation. If missingness in the outcome is
present or if time-to-event outcome, must be provided.}

\item{compete}{[\code{character}]\cr
An optional vector of column names of competing risk indicators the same
length as the number of time points of observation.}

\item{shift}{[\code{closure}]\cr
A two argument function that specifies how treatment variables should be shifted.
See examples for how to specify shift functions for continuous, binary, and categorical exposures.}

\item{shifted}{[\code{data.frame}]\cr
An optional data frame, the same as in \code{data}, but modified according
to the treatment policy of interest. If specified, \code{shift} is ignored.}

\item{estimator}{[\code{character(1)}]\cr
The estimator to use. Either \code{"lmtp_tmle"} or \code{"lmtp_sdr"}.}

\item{k}{[\code{integer(1)}]\cr
An integer specifying how previous time points should be
used for estimation at the given time point. Default is \code{Inf},
all time points.}

\item{mtp}{[\code{logical(1)}]\cr
Is the intervention of interest a modified treatment policy?
Default is \code{TRUE}. If treatment variables are continuous this should be \code{TRUE}.
If the treatment variables are not continuous, setting this to \code{FALSE} may improve performance.}

\item{id}{[\code{character(1)}]\cr
An optional column name containing cluster level identifiers.}

\item{learners_outcome}{[\code{character}]\cr A vector of \code{SuperLearner} algorithms for estimation
of the outcome regression. Default is \code{"SL.glm"}, a main effects GLM.}

\item{learners_trt}{[\code{character}]\cr A vector of \code{SuperLearner} algorithms for estimation
of the exposure mechanism. Default is \code{"SL.glm"}, a main effects GLM.
\bold{Only include candidate learners capable of binary classification}.}

\item{folds}{[\code{integer(1)}]\cr
The number of folds to be used for cross-fitting.}

\item{weights}{[\code{numeric(nrow(data))}]\cr
An optional vector containing sampling weights.}

\item{control}{[\code{list()}]\cr
Output of \code{lmtp_control()}.}
}
\value{
A list of class \code{lmtp_survival} containing \code{lmtp} objects for each time point.
}
\description{
Wrapper around \code{lmtp_tmle} and \code{lmtp_sdr} for survival outcomes to estimate the entire survival curve.
Estimates are reconstructed using isotonic regression to enforce monotonicity of the survival curve.
\bold{Confidence intervals correspond to marginal confidence intervals for the survival curve, not simultaneous intervals.}
}
\examples{
\donttest{
# Example 1.1
# Time-to-event analysis with a binary time-invariant exposure. Interested in
# the effect of treatment being given to all observations on the cumulative
# incidence of the outcome.
A <- "trt"
Y <- paste0("Y.", 1:6)
C <- paste0("C.", 0:5)
W <- c("W1", "W2")

curve <- lmtp_survival(sim_point_surv, A, Y, W, cens = C, folds = 1,
                       shift = static_binary_on, estimator = "lmtp_tmle")

tidy(curve)

# Example 1.2
# Time-to-event analysis with a binary time-invariant exposure and a competing-risk.
lmtp_survival(
  data = sim_competing_risks,
  trt = "A",
  cens = paste0("C", 1:5),
  compete = paste0("D", 1:5),
  baseline = paste0("W", 1:5),
  outcome = paste0("Y", 1:5),
  shift = static_binary_on,
  folds = 1
)
}
}
