% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapkeyIcon.R
\name{mapkeyIcons}
\alias{mapkeyIcons}
\title{Create a list of Mapkey icon data}
\usage{
mapkeyIcons(
  icon = "mapkey",
  color = "#ff0000",
  iconSize = 12,
  background = "#1F7499",
  borderRadius = "100\%",
  hoverScale = 1.4,
  hoverEffect = TRUE,
  hoverCSS = NULL,
  additionalCSS = NULL,
  htmlCode = NULL,
  boxShadow = TRUE
)
}
\arguments{
\item{icon}{ID of the mapkey Icon you want to use.}

\item{color}{Any CSS color (e.g. 'red','rgba(20,160,90,0.5)', '#686868', ...)}

\item{iconSize}{Size of Icon in Pixels. Default is 12}

\item{background}{Any CSS color or false for no background}

\item{borderRadius}{Any number (for circle size/2, for square 0.001)}

\item{hoverScale}{Any real number (best result in range 1 - 2, use 1 for no
effect)}

\item{hoverEffect}{Switch on/off effect on hover}

\item{hoverCSS}{CSS code (e.g. \code{"background-color:#992b00 !important;
color:#99defc !important;"})}

\item{additionalCSS}{CSS code (e.g. \code{"border:4px solid #aa3838;"})}

\item{htmlCode}{e.g. \code{'&#57347;&#xe003;'}.}

\item{boxShadow}{Should a shadow be visible}
}
\value{
A list of mapkey-icon data that can be passed to the argument \code{icon}
}
\description{
An icon can be represented as a list of the form \code{list(color, iconSize,
...)}. This function is vectorized over its arguments to create a list of
icon data. Shorter argument values will be re-cycled. \code{NULL} values for
these arguments will be ignored.
}
\examples{
\dontrun{
library(leaflet)
leaflet() \%>\%
  addMapkeyMarkers(
    data = breweries91,
    icon = mapkeyIcons(
      color = "red",
      borderRadius = 0,
      iconSize = 25
    )
  )
}
}
\references{
\url{https://github.com/mapshakers/leaflet-mapkey-icon}
}
\seealso{
Other Mapkey Functions: 
\code{\link{[.leaflet_mapkey_icon_set}()},
\code{\link{addMapkeyMarkers}()},
\code{\link{makeMapkeyIcon}()},
\code{\link{mapkeyIconList}()}
}
\concept{Mapkey Functions}
