% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easyprint.R
\name{addEasyprint}
\alias{addEasyprint}
\title{Add easyPrint Plugin}
\usage{
addEasyprint(map, options = easyprintOptions())
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}}}

\item{options}{A named list of options. See \code{\link{easyprintOptions}}}
}
\value{
A leaflet map object
}
\description{
Add a control, which allows to print or export a map as .PNG.
}
\examples{
library(leaflet)
leaflet() \%>\%
  addTiles() \%>\%
  addEasyprint(options = easyprintOptions(
    title = "Print map",
    position = "bottomleft",
    exportOnly = TRUE
  ))
}
\references{
\url{https://github.com/rowanwins/leaflet-easyPrint}
}
\seealso{
Other EasyPrint Functions: 
\code{\link{easyprintMap}()},
\code{\link{easyprintOptions}()},
\code{\link{removeEasyprint}()}
}
\concept{EasyPrint Functions}
