% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labels.R
\name{addStaticLabels}
\alias{addStaticLabels}
\title{Add static labels to \code{leaflet} or \code{mapview} objects}
\usage{
addStaticLabels(map, data, label, group = NULL, layerId = NULL, ...)
}
\arguments{
\item{map}{A \code{leaflet} or \code{mapview} object.}

\item{data}{A \code{sf} or \code{Spatial*} object used for label placement,
defaults to the locations of the first dataset in 'map'.}

\item{label}{The labels to be placed at the positions indicated by 'data' as
\code{character}, or any vector that can be coerced to this type.}

\item{group}{the group of the static labels layer.}

\item{layerId}{the layerId of the static labels layer.}

\item{...}{Additional arguments passed to
\code{\link[leaflet]{labelOptions}}.}
}
\value{
A labelled \strong{leaflet} map
}
\description{
Being a wrapper around \code{\link[leaflet]{addLabelOnlyMarkers}}, this
function provides a smart-and-easy solution to add custom text labels to an
existing \code{leaflet} or \code{mapview} map object.
}
\examples{
\dontrun{
## leaflet label display options
library(leaflet)

lopt = labelOptions(noHide = TRUE,
                    direction = 'top',
                    textOnly = TRUE)

## Add labels on a Leaflet map

indata <- sf::st_read(system.file("shape/nc.shp", package="sf"))

leaflet(indata) \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addFeatures(.) \%>\%
  addStaticLabels(., label = indata$NAME)

Modify styling -

leaflet(indata) \%>\%
  addProviderTiles("OpenStreetMap") \%>\%
  addFeatures(.) \%>\%
  addStaticLabels(., label = indata$NAME,
                    style = list("color" = "red", "font-weight" = "bold"))

}

}
\seealso{
\code{\link[leaflet]{addLabelOnlyMarkers}}.
}
\author{
Florian Detsch, Lorenzo Busetto
}
