% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kssa_plot.R
\name{kssa_plot}
\alias{kssa_plot}
\title{kssa_plot function}
\usage{
kssa_plot(results, type, metric)
}
\arguments{
\item{results}{An object with results produced with function \code{\link{kssa}}}

\item{type}{A character value with the type of plot to show.
It can be "summary" or "complete".}

\item{metric}{A character with the performance metric to be plotted.
It can be  "rmse", "mase," "cor", or "smape"

\itemize{
\item{"rmse" -  Root Mean Squared Error} (default choice)
\item{"mase" - Mean Absolute Scaled Error}
\item{"smape" - Symmetric Mean Absolute Percentage Error}
\item{"cor" - Pearson correlation coefficient}
}

For further details on these metrics please check package Metrics}
}
\value{
A plot of kssa results in which imputation methods are ordered
from lower to higher (left to right) error.
}
\description{
Function to plot the results of kssa for easy interpretation
}
\examples{
\donttest{
# Example 1: Plot the results from comparing all imputation methods

library("kssa")
library("imputeTS")

# Create 20\% random missing data in tsAirgapComplete time series from imputeTS
airgap_na <- missMethods::delete_MCAR(as.data.frame(tsAirgapComplete), 0.2)

# Convert to time series object
airgap_na_ts <- ts(airgap_na, start = c(1959, 1), end = c(1997, 12), frequency = 12)

# Apply the kssa algorithm with 5 segments,
# 10 iterations, 20\% of missing data, and
# compare among all available methods in the package.
# Remember that percentmd must match with
# the real percentage of missing data in the input time series

results_kssa <- kssa(airgap_na_ts,
  start_methods = "all",
  actual_methods = "all",
  segments = 5,
  iterations = 10,
  percentmd = 0.2
)

kssa_plot(results_kssa, type = "complete", metric = "rmse")

# Conclusion: Since kssa_plot is ordered from lower to
# higher error (left to right), method 'linear_i' is the best to
# impute missing data in airgap_na_ts. Notice that method 'locf' is the worst

# To obtain imputations with the best method, or any method of preference
# please use function get_imputations
}



# Example 2: Plot the results when only applying locf and linear interpolation

library("kssa")
library("imputeTS")

# Create 20\% random missing data in tsAirgapComplete time series from imputeTS
airgap_na <- missMethods::delete_MCAR(as.data.frame(tsAirgapComplete), 0.2)

# Convert to time series object
airgap_na_ts <- ts(airgap_na, start = c(1959, 1), end = c(1997, 12), frequency = 12)

# Apply the kssa algorithm with 5 segments,
# 10 iterations, 20\% of missing data, and compare among all
# applied methods (locf and linear interpolation).
# Remember that percentmd must match with
# the real percentage of missing data in the input time series

results_kssa <- kssa(airgap_na_ts,
  start_methods = c("linear_i", "locf"),
  actual_methods = c("linear_i", "locf"),
  segments = 5,
  iterations = 10,
  percentmd = 0.2
)

kssa_plot(results_kssa, type = "complete", metric = "rmse")


}
