% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upcr.R
\name{upcr_uacr}
\alias{upcr_uacr}
\title{Convert UPCR to UACR with clinical covariates}
\usage{
upcr_uacr(
  df,
  sex_col,
  diabetes_col,
  hypertension_col,
  upcr_col,
  female_str = "female"
)
}
\arguments{
\item{df}{A data.frame containing the required columns.}

\item{sex_col}{Column name with sex labels, character. Example: "sex".}

\item{diabetes_col}{Column name with diabetes indicator, 0 or 1, or logical.
Example: "diabetes".}

\item{hypertension_col}{Column name with hypertension indicator, 0 or 1, or
logical. Example: "hypertension".}

\item{upcr_col}{Column name with UPCR values. Units should match those used
to derive the model
in Sumida et al. (mg/g). If your data use different units, convert before
calling.}

\item{female_str}{String that denotes female in \code{sex_col}. Default is
"female".}
}
\value{
A numeric vector of UACR values, length \code{nrow(df)}. Non valid
rows return \code{NA_real_}.
}
\description{
Implements the equation reported by Sumida et al. for converting urine
protein–creatinine ratio
to urine albumin–creatinine ratio, with adjustments for sex, diabetes, and
hypertension.
}
\details{
The function applies a piecewise log transformation of UPCR with cut points
at 50 and 500,
and adds covariate adjustments for sex, diabetes, and hypertension, then
exponentiates to return UACR.
Valid rows require non missing diabetes and hypertension indicators. Sex is
mapped to an indicator
using \code{female_str}.
}
\examples{
df <- data.frame(
  sex = c("female", "male"),
  diabetes = c(1, 0),
  hypertension = c(0, 1),
  upcr = c(100, 400)  # mg/g (or same ratio units)
)
upcr_uacr(df, "sex", "diabetes", "hypertension", "upcr")


}
\references{
Sumida, K., Nadkarni, G. N., Grams, M. E., Sang, Y., Ballew, S. H., Coresh,
J., Matsushita, K., Surapaneni, A., Brunskill, N., Chadban, S. J., Chang, A.
R., Cirillo, M., Daratha, K. B., Gansevoort, R. T., Garg, A. X., Iacoviello,
L., Kayama, T., Konta, T., Kovesdy, C. P., Lash, J., Lee, B. J., Major, R.
W., Metzger, M., Miura, K., Naimark, D. M. J., Nelson, R. G., Sawhney, S.,
Stempniewicz, N., Tang, M., Townsend, R. R., Traynor, J. P., Valdivielso, J.
M., Wetzels, J., Polkinghorne, K. R., and Heerspink, H. J. L. (2020).
Conversion of urine protein-creatinine ratio or urine dipstick protein to
urine albumin-creatinine ratio for use in chronic kidney disease screening
and prognosis. \emph{Annals of Internal Medicine}, 173(6), 426-435.
\doi{10.7326/M20-0529}
}
