% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_cosine_similarity}
\alias{metric_cosine_similarity}
\title{Computes the cosine similarity between the labels and predictions}
\usage{
metric_cosine_similarity(
  ...,
  axis = -1L,
  name = "cosine_similarity",
  dtype = NULL
)
}
\arguments{
\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{axis}{(Optional) (1-based) Defaults to -1. The dimension along which the metric is computed.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
A (subclassed) \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage.
}
\description{
Computes the cosine similarity between the labels and predictions
}
\details{
\if{html}{\out{<div class="sourceCode">}}\preformatted{cosine similarity = (a . b) / ||a|| ||b||
}\if{html}{\out{</div>}}

See: \href{https://en.wikipedia.org/wiki/Cosine_similarity}{Cosine Similarity}.

This metric keeps the average cosine similarity between \code{predictions} and
\code{labels} over a stream of data.
}
\note{
If you want to compute the cosine_similarity for each case in a
mini-batch you can use \code{loss_cosine_similarity()}.
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_recall}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sensitivity_at_specificity}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
