% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeEquation.R
\name{writemath}
\alias{writemath}
\title{Make Equations of used model in Latex or Office}
\usage{
writemath(formula_, output = 1, verbose = FALSE)
}
\arguments{
\item{formula_}{The \strong{formula_} parameter allows a user to specify a model formula, such as \code{CPI~ER+PPI+asym(ER)+deterministic(covid)+trend}, to define the relationships in the analysis. Alternatively, if a user provide a kardl output object, the function will automatically extract all necessary variables and parameters from this object, simplifying the setup process. This flexibility enables users to define the model structure either through a formula or directly from an existing analysis object.}

\item{output}{The output parameter specifies the path and file name for saving output equations.
\itemize{
 \item \strong{MS Word Output}: If output is set with a \strong{.docx} extension, the equations will be saved as a \strong{Word} document.
 \item \strong{LaTeX Output}: If specified with a \strong{.tex} extension, the equations will be saved as a \strong{LaTeX} file.
 \item \strong{Markdown Output}: If specified with a \strong{.rm} extension, the equations will be saved as a \strong{Markdown} file.
 \item \strong{PDF Output}: If specified with a \strong{.pdf} extension, the equations will be saved as a \strong{PDF} file.
 \item \strong{Display on terminal}
 \itemize{
     \item \strong{1}: Using \strong{1} as the output displays \strong{LaTeX} formatted equations on the screen without saving to a file.
     \item \strong{2}: Setting output to \strong{2} displays equations in \strong{Markdown} on terminal.
     \item \strong{3}: Setting output to \strong{3} displays the equations as \strong{OpenOffice}-compatible math formulas on terminal.
         }
}

If \emph{output} is specified without directory paths (i.e., without / for Linux or \\\\ for Windows), the file will be saved in the current working directory. This feature ensures that, in the absence of a specified path, files are saved to a known default location.

See examples for details}

\item{verbose}{A logical value indicating whether to print the generated formula to the console when not saving to a file. If set to TRUE, the function will display the formula; if FALSE, it will not print anything. This parameter is useful for users who want to see the output directly in the console without saving it to a file.}
}
\value{
print or save
}
\description{
The \strong{writemath} function generates all necessary equations for analysis, including those for ARDL, NARDL, short-run and long-run nonlinearities, and dynamic multipliers. It produces these equations in multiple formats: as text and as files compatible with MS Word, Markdown, LaTeX, and LibreOffice. This function provides a comprehensive set of formulas essential for econometric analysis, facilitating easy access to equations across various document formats for efficient reporting and presentation.
}
\examples{
# Note: The file creations in this examples were deactivated in the current examples
# because of CRAN policies.

# For saving all equations in a MS word document, \strong{docx}.
# The directory can be added alongside of the file name.
# For Windows OS directories could be written as \\ not /.

# Here the tempdir() function is used to get a temporary directory path.
# Users can replace this with their desired directory path.

\donttest{
writemath(y~x+z+asym(v)+asymL(q+a),tempfile(fileext = ".docx"))
}

# For Markdown file the extenssion of the file should be assigned as \strong{md}.
\donttest{
writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),tempfile(fileext = ".md"))
}

# All equations are able to be saved in a PDF file.
\donttest{
writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),tempfile(fileext = ".pdf"))
}




# Following commad saves LibreOffice formulas in terminal.

# Copy and paste formulas there and after selecting related formula click on formula icon.

kardl_model<-kardl(imf_example_data,CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,mode=c(1,2,3,0))

# Following command writes all equations in a latex file in current directory.

# Note: The file creations in this examples were deactivated because of CRAN policies.

\donttest{
tmp <- tempfile(fileext = ".tex")
writemath(kardl_model,tmp)
}

# For printing the equations in Latex fomrat assignning of file name to 1 is required.
# A user's formula can be written directly in the function.
eq1 <- writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),1)

# To get all of the N/ARDL equations (in LaTeX format):
# Note: Here the output is limited to 1000 characters for better visibility.
print(eq1,1000)




# To saving outputs for different output type, in a list is available.
eq2 <- writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),1)
# To get the equations' subcomponents, here the long-run equation (in LaTeX format):
eq2$formulas$longRunEqFormula

# For printing the equations in Markdown fomrat assignning of file name to 2 is required.
eq3<- writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),2)
# To get the ECM equation (in Markdown format):
eq3$formulas$ECMEqFormula

# For printing the equations in OpenOffice fomrat assignning of file name to 3 is required.
eq4<-writemath(y~x+z+asym(v+w)+asymL(q+a)+asymS(m),3)
# To get the NARDL equation (in LibreOffice format):
eq4$formulas$NARDL_eq_Formula
}
\seealso{
\code{\link{kardl}}, \code{\link{kardl_longrun}}
}
