% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{parseFormula}
\alias{parseFormula}
\title{Extract Variables from a Formula}
\usage{
parseFormula(formula_, matchPattern = "asym", ignore.case = FALSE)
}
\arguments{
\item{formula_}{The initial formula for the model, typically specified using R's formula syntax (e.g.,  \code{y ~ x + f(x1 + x2)}).}

\item{matchPattern}{A string or vector of strings that specifies the function(s) in the formula from which to extract variables. For example, \code{matchPattern = "f()"} will target variables within \code{f(...)} in the formula.}

\item{ignore.case}{Logical; if \code{FALSE} (default), pattern matching is case-sensitive; if \code{TRUE}, case is ignored during matching.

A logical value indicating whether pattern matching should be case-sensitive (\code{FALSE}) or case-insensitive (\code{TRUE}).}
}
\value{
A list containing:
\itemize{
   \item   Parsed variables: Variables that are located within the specified \code{matchPattern} part of the formula.
   \item   Remaining model: The rest of the formula, excluding the parsed variables.
   }
}
\description{
The \code{parseFormula()} unction extracts and lists variables from specific parts of a formula, especially those within parentheses of specified function types. This enables users to isolate and analyze segments of a model formula, such as variables within custom functions, with an option to ignore case sensitivity in pattern matching.
}
\examples{

# Identify variables within specific functions, such as 'asymS'
parsed<-parseFormula(y ~ x +det(s + d) + asymS(d + s),"asymS()")
parsed

 # Parse formulas containing various collection types like () or []
formula_ <- y ~ x +det(s -gg- d) + asymS(d2 -rr+ s)-mm[y1+y2+y3]+asym[k1+k2+k3]+trend-huseyin

# Extract variables in the 'asymS' function
parseFormula(formula_,"asymS")

# Use multiple functions to extract variables. If a specified function, such as "uuu",
# is not found, nothing is returned for it
a<-parseFormula(formula_,c("mm","det","uuu"))

 # To obtain variables not enclosed within any function, specify them directly
 parseFormula(formula_,c("trend","huseyin"))

# By default, 'parseFormula()' is case-sensitive.
# For case-insensitive matching, set 'ignore.case = TRUE'

parseFormula(formula_,"asyms", TRUE)
}
\seealso{
\code{\link{replaceValues}}, \code{\link[stats]{formula}}
}
