% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{kardl_reset}
\alias{kardl_reset}
\title{Function to reset kardl package settings}
\usage{
kardl_reset(. = FALSE)
}
\arguments{
\item{.}{If provided and not `FALSE`, the function will return this value after resetting the settings. If not provided or set to `FALSE`, it will return the current settings.}
}
\value{
Returns the default options as a list.
}
\description{
This function resets all options in the kardl package to their default values.
}
\examples{
# Set some options
kardl_set(criterion = "BIC", differentAsymLag = TRUE)
# Reset to default values
kardl_get("criterion")  # Check current settings
kardl_reset()
kardl_get("criterion")  # Check settings after reset

library(magrittr)
 MyFormula<-CPI~ER+PPI+asym(ER)+deterministic(covid)+trend
imf_example_data \%>\%
  kardl_set(LongCoef= "K1{lag}w1{varName}",differentAsymLag= FALSE ) \%>\%  kardl(MyFormula ) \%>\%
    kardl_reset()
kardl_get()

imf_example_data \%>\%
  kardl_reset() \%>\%
    kardl_set(LongCoef= "K2{lag}w2{varName}",differentAsymLag=FALSE ) \%>\%  kardl(MyFormula)

kardl_get(c("LongCoef","differentAsymLag","ShortCoef","batch"))

}
\seealso{
\code{\link{kardl_set}}, \code{\link{kardl_get}}
}
