% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxreg_multivar.R
\name{h_extract_coxreg_multivar}
\alias{h_extract_coxreg_multivar}
\title{Extract Estimates from Multivariate Cox Regression Model Fit Object}
\usage{
h_extract_coxreg_multivar(x)
}
\arguments{
\item{x}{(\code{coxreg.multivar})\cr from \code{\link[tern:fit_coxreg]{tern::fit_coxreg_multivar()}}.}
}
\value{
A data frame containing Cox regression results with columns for term,
coef_se (coefficient and standard error), p.value, hr (hazard ratio),
hr_ci (confidence interval for hazard ratio), and labels (formatted term labels).
}
\description{
Extract Estimates from Multivariate Cox Regression Model Fit Object
}
\examples{
anl <- tern::tern_ex_adtte |>
  dplyr::mutate(EVENT = 1 - CNSR)

variables <- list(
  time = "AVAL",
  event = "EVENT",
  arm = "ARM",
  covariates = c("SEX", "AGE")
)

control <- tern::control_coxreg(
  conf_level = 0.9,
  ties = "efron"
)

fit <- tern::fit_coxreg_multivar(
  data = anl,
  variables = variables,
  control = control
)

h_extract_coxreg_multivar(fit)
}
\keyword{internal}
