% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivx.R
\name{summary.ivx}
\alias{summary.ivx}
\alias{print.summary.ivx}
\title{Summarizing IVX Model Fits}
\usage{
\method{summary}{ivx}(object, ...)

\method{print}{summary.ivx}(
  x,
  digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{object of class "ivx", usually, a result of a call to ivx.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class \code{"summary.lm"}, usually, a result of a
    call to \code{summary.lm}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}
}
\description{
summary method for class "ivx".
}
\examples{
mod <- ivx(Ret ~ LTY, data = monthly)

summary(mod)
}
