% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/address_ranges.R
\name{summarize_address_range}
\alias{summarize_address_range}
\title{List constituent networks of an address range}
\usage{
summarize_address_range(address1, address2)
}
\arguments{
\item{address1}{An \code{\link{ip_address}} vector}

\item{address2}{An \code{\link{ip_address}} vector}
}
\value{
A list of \code{\link{ip_network}} vectors
}
\description{
Given an address range, this returns the list of constituent networks.

If you know the address range matches the boundaries of a single network, it
might be preferable to use \code{\link[=common_network]{common_network()}}. This returns an \code{\link{ip_network}}
vector instead of a list of \code{\link{ip_network}} vectors.
}
\examples{
# address range matches network boundaries
summarize_address_range(ip_address("192.168.0.0"), ip_address("192.168.0.15"))

# address range does not match network boundaries
summarize_address_range(ip_address("192.167.255.255"), ip_address("192.168.0.16"))
}
\seealso{
\code{\link[=common_network]{common_network()}}
}
