% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iotables_download.R
\name{iotables_download}
\alias{iotables_download}
\title{Download input–output tables (Eurostat)}
\usage{
iotables_download(
  source = "naio_10_cp1700",
  data_directory = NULL,
  force_download = FALSE
)
}
\arguments{
\item{source}{Character. The Eurostat product code (see above) or \code{"uk_2010"}.}

\item{data_directory}{Optional directory path where the processed nested
tables will be saved as \code{"<source>_processed.rds"}. If \code{NULL} (default),
results are saved to \code{tempdir()}.}

\item{force_download}{Logical. If \code{FALSE} (default), reuse a cached file
in \code{data_directory} or \code{tempdir()} when available. If \code{TRUE}, force a
fresh download from Eurostat.}
}
\value{
A \strong{nested} \code{data.frame} (one row per IO table) with metadata columns
(\code{geo}, \code{unit}, \code{year}, \code{stk_flow}, etc.) and a list-column \code{data}
containing the tidy table for each combination.
}
\description{
Download standard input–output (IO) and related tables. At the moment,
only Eurostat products are supported. You usually do not need to call
this directly; \code{\link[=iotable_get]{iotable_get()}} will invoke it as needed and return a
filtered, tidy table.
}
\details{
Files are cached under \code{tempdir()} as RDS (e.g., \code{"naio_10_cp1750.rds"}).
The temporary directory is cleared when the R session ends. To persist
downloads across sessions (recommended for analytics), supply
\code{data_directory} and the processed, \strong{nested} output will also be
written there as \code{"<source>_processed.rds"}.

Supported Eurostat products include (non-exhaustive):
\itemize{
\item \code{naio_10_cp1700} — Symmetric IO table, basic prices (product × product)
\item \code{naio_10_pyp1700} — Same, previous years’ prices
\item \code{naio_10_cp1750} — Symmetric IO table, basic prices (industry × industry)
\item \code{naio_10_pyp1750} — Same, previous years’ prices
\item \code{naio_10_cp15} — Supply table at basic prices incl. margins/taxes
\item \code{naio_10_cp16} — Use table at purchasers’ prices
\item \code{naio_10_cp1610} — Use table at basic prices
\item \code{naio_10_pyp1610} — Use table at basic prices (previous years’ prices)
\item \code{naio_10_cp1620} — Trade and transport margins at basic prices
\item \code{naio_10_pyp1620} — Trade and transport margins at previous years’ prices
\item \code{naio_10_cp1630} — Taxes less subsidies on products at basic prices
\item \code{naio_10_pyp1630} — Taxes less subsidies on products, prev. years’ prices
\item \code{uk_2010} — United Kingdom IO Analytical Tables (handled internally)
}

Eurostat API/format changes (e.g., \code{TIME_PERIOD} vs \code{time}) are handled
for backward compatibility.
}
\examples{
\donttest{
io_tables <- iotables_download(source = "naio_10_pyp1750")
}

}
\seealso{
Other import functions: 
\code{\link{airpol_get}()},
\code{\link{employment_get}()},
\code{\link{iotables_metadata_get}()},
\code{\link{iotables_read_tempdir}()}
}
\concept{import functions}
