% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment.R
\name{cIndex}
\alias{cIndex}
\title{Concordance Index}
\usage{
cIndex(time, event = NULL, risk_score, weight = NULL)
}
\arguments{
\item{time}{A numeric vector for observed times}

\item{event}{A numeric vector for event indicators.  If it is \code{NULL}
(by default) or \code{NA}, \code{event} will be treated all as ones and
the function will compute concordance index for uncensored survival
data.}

\item{risk_score}{A numeric vector representing the risk scores of events.}

\item{weight}{A optional numeric vector for weights.  If it is \code{NULL}
(by default) or \code{NA}, equal weights will be used.}
}
\value{
A named numeric vector that consists of
\itemize{
  \item \code{index}: the concordance index.
  \item \code{concordant}: the number of concordant pairs.
  \item \code{comparable}: the number of comparable pairs.
  \item \code{tied_tisk}: the number of comparable pairs having tied risks.
}
}
\description{
Compute concordance index (C-index or C-statistic) that allows weights for
right-censored survival data.  For example, Asano and Hirakawa (2017)
proposed cure status weighting for cure models, which reduces to Harrell's
C-index if weighs are all ones.
}
\details{
Let \eqn{r_i}, \eqn{t_i}, and \eqn{\delta_i} denote the risk score, observed
time, and event indicator of \eqn{i}-th subject.  The pair of
\eqn{(t_i,\delta_i)} and \eqn{(t_j,\delta_j)}, where \eqn{i<j}, are defined
to be comparable if \eqn{t_i<t_j,\delta_i=1} or
\eqn{t_i=t_j,\delta_i=1,\delta_j=0}.  In the context of survival analysis,
the risk scores of a comparable pair are said to be concordant with the
survival outcomes if \eqn{r_i>r_j}.  The C-index is defined as the
proportion of the concordant pairs among the comparable pairs.  For
comparable pair satisfying \eqn{t_i<t_j,\delta_i=1}, we count 0.5 in the
numerator of the concordance index for tied risk scores (\eqn{r_i=r_j}).
}
\examples{
## See examples of function 'cox_cure'.
}
\references{
Asano, J., & Hirakawa, A. (2017). Assessing the prediction accuracy of a
cure model for censored survival data with long-term survivors: Application
to breast cancer data. Journal of Biopharmaceutical Statistics, 27(6),
918--932.

Harrell, F. E., Lee, K. L., & Mark, D. B. (1996). Multivariable prognostic
models: Issues in developing models, evaluating assumptions and adequacy,
and measuring and reducing errors. Statistics in medicine, 15(4), 361--387.
}
