% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volterra.R
\name{volterra_solve}
\alias{volterra_solve}
\title{Solve a Volterra equation of the first kind}
\usage{
volterra_solve(
  k,
  f = function(x) x,
  a = 0,
  b = 1,
  num = 1000L,
  method = c("midpoint", "trapezoid")
)
}
\arguments{
\item{k}{kernel function of two time scales}

\item{f}{left hand side (free) function with f(a)=0}

\item{a}{lower bound of the integral}

\item{b}{upper bound of the integral}

\item{num}{integer for the number of evaluation points}

\item{method}{string for the method}
}
\value{
data-frame with evaluation points 'sgrid' and calculations 'ggrid'
}
\description{
Solve a Volterra equation of the first kind
}
\examples{
k <- function(s,t) {
        cos(t-s)
}
trueg <- function(s) {
    (2+s**2)/2
}

res <- volterra_solve(k,a=0,b=1,num=1000)

plot(
    res$sgrid, res$ggrid,
    type = "l",
    col = "blue",
    xlim = c(0, 1),
    #ylim = c(-1, 1),
    xlab = "s",
    ylab = "g(s)",
    main = "Volterra Equation Solution first kind"
)
# add the true solution
lines(res$sgrid, trueg(res$sgrid), col = "red", lty = 2)
legend( 
    "topright",
    legend = c("Estimated Value", "True Value"),
    col = c("blue", "red"),
    lty = c(1, 2)
)
}
