% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/n_parameters.R
\name{n_parameters}
\alias{n_parameters}
\alias{n_parameters.default}
\alias{n_parameters.merMod}
\alias{n_parameters.glmmTMB}
\title{Count number of parameters in a model}
\usage{
n_parameters(x, ...)

\method{n_parameters}{default}(x, remove_nonestimable = FALSE, ...)

\method{n_parameters}{merMod}(x, effects = "fixed", remove_nonestimable = FALSE, ...)

\method{n_parameters}{glmmTMB}(
  x,
  effects = "fixed",
  component = "all",
  remove_nonestimable = FALSE,
  ...
)
}
\arguments{
\item{x}{A statistical model.}

\item{...}{Arguments passed to or from other methods.}

\item{remove_nonestimable}{Logical, if \code{TRUE}, removes (i.e. does not
count) non-estimable parameters (which may occur for models with
rank-deficient model matrix).}

\item{effects}{Should variables for fixed effects (\code{"fixed"}), random effects
(\code{"random"}) or both (\code{"all"}) be returned? Only applies to mixed models. May
be abbreviated.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}
}
\value{
The number of parameters in the model.
}
\description{
Returns the number of parameters (coefficients) of a model.
}
\note{
This function returns the number of parameters for the fixed effects by
default, as returned by \code{find_parameters(x, effects = "fixed")}. It does not
include \emph{all} estimated model parameters, i.e. auxiliary parameters like
sigma or dispersion are not counted. To get the number of \emph{all estimated}
parameters, use \code{get_df(x, type = "model")}.
}
\examples{
data(iris)
model <- lm(Sepal.Length ~ Sepal.Width * Species, data = iris)
n_parameters(model)
}
