% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_model.R
\name{download_model}
\alias{download_model}
\title{Download circus models}
\usage{
download_model(
  name,
  url = "https://raw.github.com/easystats/circus/master/data/",
  extension = ".rda",
  verbose = TRUE
)
}
\arguments{
\item{name}{Model name.}

\item{url}{String with the URL from where to download the model data.
Optional, and should only be used in case the repository-URL is
changing. By default, models are downloaded from
\verb{https://raw.github.com/easystats/circus/master/data/}.}

\item{extension}{File extension. Default is \code{.rda}.}

\item{verbose}{Toggle messages and warnings.}
}
\value{
A model from the \emph{circus}-repository, or \code{NULL} if model could
not be downloaded (e.g., due to server problems).
}
\description{
Downloads pre-compiled models from the \emph{circus}-repository.
The \emph{circus}-repository contains a variety of fitted models to help
the systematic testing of other packages
}
\details{
The code that generated the model is available at the
\url{https://easystats.github.io/circus/reference/index.html}.
}
\examples{
\dontshow{if (require("httr2", quietly = TRUE) && curl::has_internet() && interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
download_model("aov_1")
try(download_model("non_existent_model"))
}
\dontshow{\}) # examplesIf}
}
\references{
\url{https://easystats.github.io/circus/}
}
