% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappers.R
\name{bm_aggregate}
\alias{bm_aggregate}
\alias{bru_mapper_aggregate}
\alias{ibm_n.bm_aggregate}
\alias{ibm_n_output.bm_aggregate}
\alias{ibm_values.bm_aggregate}
\alias{ibm_jacobian.bm_aggregate}
\alias{ibm_eval.bm_aggregate}
\title{Mapper for aggregation}
\usage{
bm_aggregate(rescale = FALSE, n_block = NULL, type = NULL)

bru_mapper_aggregate(...)

\method{ibm_n}{bm_aggregate}(mapper, ..., input = NULL, state = NULL, n_state = NULL)

\method{ibm_n_output}{bm_aggregate}(mapper, input = NULL, ...)

\method{ibm_values}{bm_aggregate}(mapper, ..., state = NULL, n_state = NULL)

\method{ibm_jacobian}{bm_aggregate}(mapper, input, state = NULL, ...)

\method{ibm_eval}{bm_aggregate}(mapper, input, state = NULL, ..., sub_lin = NULL)
}
\arguments{
\item{rescale}{logical; For \code{bm_aggregate} and \code{bm_logsumexp},
specifies if the blockwise sums should be normalised by the blockwise weight
sums or not:
\itemize{
\item \code{FALSE}: (default) Straight weighted sum, no rescaling.
\item \code{TRUE}: Divide by the sum of the weight values within each block.
This is useful for integration averages, when the given weights are plain
integration weights. If the weights are \code{NULL} or all ones, this is
the same as dividing by the number of entries in each block.
}}

\item{n_block}{Predetermined number of output blocks. If \code{NULL}, overrides
the maximum block index in the inputs. The priority order is \code{input$n_block},
the mapper definition \code{n_block}, then \code{max(input$block)}.}

\item{type}{character; if non-NULL, overrides the \code{rescale} argument, and
constructs an aggregation mapper of the given type instead. Supported
values are "sum", "average", "logsumexp", and "logaverageexp".}

\item{...}{Arguments passed on to other methods}

\item{mapper}{A mapper S3 object, inheriting from \code{bru_mapper}.}

\item{input}{Data input for the mapper.}

\item{state}{A vector of latent state values for the mapping,
of length \code{ibm_n(mapper, inla_f = FALSE)}}

\item{n_state}{integer giving the length of the state vector for mappers
that have state dependent output size.}

\item{sub_lin}{Internal, optional pre-computed sub-mapper information}
}
\description{
Constructs a mapper
that aggregates elements of the input state, so it can be used e.g.
for weighted summation or integration over blocks of values.
}
\section{Methods (by generic)}{
\itemize{
\item \code{ibm_jacobian(bm_aggregate)}: \code{input} should be a list with elements \code{block}
and \code{weights}. \code{block}
should be a vector of the same length as the \code{state}, or \code{NULL}, with \code{NULL}
equivalent to all-1.
If \code{weights} is \code{NULL}, it's interpreted as all-1.

}}
\examples{
m <- bm_aggregate()
ibm_eval2(m, list(block = c(1, 2, 1, 2), weights = 1:4), 11:14)
ibm_eval2(m, list(block = c(1, 2, 1, 2), weights = 1:4, n_block = 3), 11:14)

}
\seealso{
\link{bru_mapper}, \link{bru_mapper_generics}

Other mappers: 
\code{\link{bm_collect}()},
\code{\link{bm_const}()},
\code{\link{bm_factor}()},
\code{\link{bm_fmesher}()},
\code{\link{bm_harmonics}()},
\code{\link{bm_index}()},
\code{\link{bm_linear}()},
\code{\link{bm_logsumexp}()},
\code{\link{bm_marginal}()},
\code{\link{bm_matrix}()},
\code{\link{bm_mesh_B}()},
\code{\link{bm_multi}()},
\code{\link{bm_pipe}()},
\code{\link{bm_repeat}()},
\code{\link{bm_scale}()},
\code{\link{bm_shift}()},
\code{\link{bm_sum}()},
\code{\link{bm_taylor}()},
\code{\link{bru_get_mapper}()},
\code{\link{bru_mapper}()},
\code{\link{bru_mapper.fm_mesh_1d}()},
\code{\link{bru_mapper.fm_mesh_2d}()},
\code{\link{bru_mapper_generics}}
}
\concept{mappers}
