% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata_series.R
\name{get_metadata_series}
\alias{get_metadata_series}
\title{Get information for a specific series}
\usage{
get_metadata_series(
  codSeries = NULL,
  det = 0,
  tip = NULL,
  lang = "ES",
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{codSeries}{(string): code of the series. For further information about
codes click this \href{https://es-ine.github.io/ineapir/articles/identify_codes.html}{link}.}

\item{det}{(int): level of detail. Valid values: 0, 1 or 2.}

\item{tip}{(string): set to 'A' for friendly output (e.g. readable dates),
set to 'M' to include metadata or set to 'AM' for both.}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{validate}{(logical): validate input parameters.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of a series according to the code specified in the function
}
\description{
Get information for a specific series
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get information of time series with code "IPC206449"
df <- get_metadata_series(codSeries = "IPC206449")
head(df)
\dontshow{\}) # examplesIf}
}
