% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metadata.R
\name{get_metadata_operations}
\alias{get_metadata_operations}
\title{Get all available operations}
\usage{
get_metadata_operations(
  operation = NULL,
  lang = "ES",
  geo = NULL,
  page = 0,
  validate = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{operation}{(string): code of the operation. To obtain a list of
available operations see \code{\link[=get_metadata_operations]{get_metadata_operations()}}.
If no operation is specified then all the operations will be shown}

\item{lang}{(string): language of the retrieved data. Set to 'ES' for Spanish or set to 'EN' for English.}

\item{geo}{(int): set to 0 for operations with national data or set to 1 for operations with data with
a greater level of disaggregation.}

\item{page}{(int): page number. The retrieved result of the query is paginated (page=0 retrieves all pages).}

\item{validate}{(logical): validate input parameters. A FALSE value means fewer API calls.}

\item{verbose}{(logical): print additional information, including the URL to call the API service.}
}
\value{
Data frame with information of the available operations
}
\description{
Get all available operations
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get all operations
df <- get_metadata_operations()
head(df)

# Get a specific operation
df <- get_metadata_operations(operation = "IPC", validate = FALSE)
head(df)

# Get operations with territorial disaggregation
df <- get_metadata_operations(geo = 1)
head(df)
\dontshow{\}) # examplesIf}
}
